/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.util;

import com.github.yzqdev.skirkmod.SkirkModClient;
import com.github.yzqdev.skirkmod.sound.SoundConfUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1646;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;

public class GlobalHelper {
    public static boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean isVillagerInventoryEmpty(class_1646 villager) {
        for (int i = 0; i < villager.method_35199().method_5439(); ++i) {
            if (villager.method_35199().method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)"skirk", (String)path);
    }

    public static void copyTexturesToConfig() {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        Predicate<class_2960> filter = name -> name.method_12832().endsWith(".ogg");
        try {
            Map resources = resourceManager.method_14488("sounds/nilu", filter);
            Path configFolder = Path.of(class_310.method_1551().field_1697.getAbsolutePath(), "config", "skirk");
            if (!configFolder.toFile().exists()) {
                Files.createDirectories(configFolder, new FileAttribute[0]);
                resources.forEach((resourceLocation, resourceSet) -> {
                    try {
                        InputStream inputStream = resourceSet.method_14482();
                        Path destination = configFolder.resolve(resourceLocation.method_12832());
                        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                        Files.copy(inputStream, destination, StandardCopyOption.REPLACE_EXISTING);
                        System.out.println("Copied sounds: " + String.valueOf(resourceLocation));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyFolder(Path source, Path target) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            SkirkModClient.LOGGER.error("Source must be a directory");
        }
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        Files.walk(source, new FileVisitOption[0]).forEach(srcPath -> {
            try {
                String relativePath = source.relativize((Path)srcPath).toString();
                Path destPath = target.resolve(relativePath);
                System.out.println("Copying: " + String.valueOf(srcPath) + " -> " + String.valueOf(destPath));
                if (Files.isDirectory(srcPath, new LinkOption[0])) {
                    Files.createDirectories(destPath, new FileAttribute[0]);
                } else {
                    Files.copy(srcPath, destPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
            }
            catch (IOException e) {
                SkirkModClient.LOGGER.error("Failed to copy: " + String.valueOf(srcPath), (Throwable)e);
            }
        });
    }

    public static void copySounds() {
        try {
            if (!Files.exists(SoundConfUtil.CONFIG_FOLDER, new LinkOption[0])) {
                Files.createDirectory(SoundConfUtil.CONFIG_FOLDER, new FileAttribute[0]);
                SkirkModClient.LOGGER.info("create skirk config folder:" + SoundConfUtil.CONFIG_FOLDER.toString());
                if (!Files.exists(SoundConfUtil.SOUND_FOLDER, new LinkOption[0])) {
                    Files.createDirectory(SoundConfUtil.SOUND_FOLDER, new FileAttribute[0]);
                }
            }
            Path from = Path.of(GlobalHelper.class.getClassLoader().getResource("sounds").toURI());
            Path to = SoundConfUtil.SOUND_FOLDER;
            GlobalHelper.copyFolder(from, to);
        }
        catch (Exception e) {
            SkirkModClient.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static class_2338 vec3ToBlockPos(class_243 vec) {
        int x = (int)Math.floor(vec.field_1352);
        int y = (int)Math.floor(vec.field_1351);
        int z = (int)Math.floor(vec.field_1350);
        return new class_2338(x, y, z);
    }

    public static class_2338 vec3ToBlockPos(double x, double y, double z) {
        return new class_2338((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    public static int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            int num2;
            int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (num1 == num2) continue;
            return Integer.compare(num1, num2);
        }
        return 0;
    }
}

