/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.damageindicator;

import com.github.yzqdev.skirkmod.damageindicator.DamageTextHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3959;
import net.minecraft.class_4597;
import net.minecraft.class_8111;
import net.minecraft.class_898;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class DamageTextRenderer {
    public static void onRenderWorldStage(Quaternionf rotation) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        class_898 renderManager = mc.method_1561();
        class_327 fontRenderer = mc.field_1772;
        long currentTime = System.currentTimeMillis();
        ArrayList<DamageTextHandler.DamageText> damageTexts = new ArrayList<DamageTextHandler.DamageText>(DamageTextHandler.getDamageTexts());
        damageTexts.removeIf(text -> currentTime - text.getTimestamp() > 1000L);
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        for (DamageTextHandler.DamageText text2 : damageTexts) {
            Matrix4f matrix = new Matrix4f();
            if (text2 == null || !DamageTextRenderer.hasLineOfSight((class_1309)mc.field_1724, mc.field_1724.method_37908(), (float)text2.getX(), (float)text2.getY(), (float)text2.getZ())) continue;
            long age = currentTime - text2.getTimestamp();
            float progress = age / text2.getDuration();
            float alpha = 1.0f - progress;
            float scale = 1.0f + 0.5f * (1.0f - progress);
            matrix.translate((float)(text2.getX() - renderManager.field_4686.method_19326().field_1352), (float)(text2.getY() - renderManager.field_4686.method_19326().field_1351), (float)(text2.getZ() - renderManager.field_4686.method_19326().field_1350));
            matrix.rotate((Quaternionfc)rotation);
            matrix.rotateY((float)Math.PI);
            matrix.scale(-0.025f * scale, -0.025f * scale, 0.025f * scale);
            matrix.translate(0.0f, -progress * 25.0f, 0.0f);
            class_327.class_6415 displayMode = class_327.class_6415.field_33994;
            String damage = String.format("%.0f", Float.valueOf(text2.getDamage()));
            int color = DamageTextRenderer.getDamageColor(text2.getDamage(), alpha).getRGB();
            int textWidth = fontRenderer.method_1727(damage);
            Objects.requireNonNull(fontRenderer);
            if (DamageTextRenderer.getDamageColor(text2.getDamage(), alpha).getAlpha() <= 25) continue;
            fontRenderer.method_27521(damage, (float)(-textWidth) / 2.0f, -4.5f, color, false, matrix, (class_4597)bufferSource, displayMode, 0, 0xF000F0);
        }
    }

    private static boolean hasLineOfSight(class_1309 player, class_1937 level, float x, float y, float z) {
        class_243 vec3 = new class_243((double)x, (double)y, (double)z);
        class_243 vec31 = new class_243(player.method_23317(), player.method_23320(), player.method_23321());
        return vec31.method_1022(vec3) <= 128.0 && level.method_17742(new class_3959(vec3, vec31, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player)).method_17783() == class_239.class_240.field_1333;
    }

    private static Color getDamageColor(float damage, float alpha) {
        if (damage > 15.0f) {
            return new Color(1.0f, 0.0f, 0.0f, alpha);
        }
        if (damage > 10.0f) {
            return new Color(1.0f, 0.13333334f, 0.13333334f, alpha);
        }
        if (damage > 7.0f) {
            return new Color(1.0f, 0.50980395f, 0.0f, alpha);
        }
        return new Color(1.0f, 0.9411765f, 0.0f, alpha);
    }

    private static Color getDamageColor(class_1282 source, float alpha) {
        if (source.method_49708(class_8111.field_42337) || source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42331)) {
            return new Color(1.0f, 0.27058825f, 0.0f, alpha);
        }
        if (source.method_49708(class_8111.field_42349) || source.method_49708(class_8111.field_42329)) {
            return new Color(0.5019608f, 0.0f, 0.5019608f, alpha);
        }
        if (source.method_49708(class_8111.field_42342)) {
            return new Color(0.0f, 1.0f, 1.0f, alpha);
        }
        if (source.method_49708(class_8111.field_42350)) {
            return new Color(0.29411766f, 0.0f, 0.50980395f, alpha);
        }
        if (source.method_49708(class_8111.field_42320) || source.method_49708(class_8111.field_42360)) {
            return new Color(0.69803923f, 0.13333334f, 0.13333334f, alpha);
        }
        return new Color(1.0f, 1.0f, 1.0f, alpha);
    }
}

