/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.gui.modify;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class LongSystemToast
implements class_368 {
    private static final int MAX_LINE_SIZE = 200;
    private static final int LINE_SPACING = 12;
    private static final int MARGIN = 10;
    private final SystemToastIds id;
    private class_2561 title;
    private List<class_5481> messageLines;
    private long lastChanged;
    private boolean changed;
    private final int width;
    private static final class_2960 BACKGROUND_SPRITE = new class_2960("toast/system");

    public LongSystemToast(SystemToastIds pId, class_2561 pTitle, class_2561 pMessage) {
        this(pId, pTitle, (List<class_5481>)LongSystemToast.nullToEmpty(pMessage), Math.max(160, 30 + Math.max(class_310.method_1551().field_1772.method_27525((class_5348)pTitle), pMessage == null ? 0 : class_310.method_1551().field_1772.method_27525((class_5348)pMessage))));
    }

    public static LongSystemToast multiline(class_310 pMinecraft, SystemToastIds pId, class_2561 pTitle, class_2561 pMessage) {
        class_327 font = pMinecraft.field_1772;
        List list = font.method_1728((class_5348)pMessage, 200);
        int i = Math.max(200, list.stream().mapToInt(arg_0 -> ((class_327)font).method_30880(arg_0)).max().orElse(200));
        return new LongSystemToast(pId, pTitle, list, i + 30);
    }

    private LongSystemToast(SystemToastIds pId, class_2561 pTitle, List<class_5481> pMessageLines, int pWidth) {
        this.id = pId;
        this.title = pTitle;
        this.messageLines = pMessageLines;
        this.width = pWidth;
    }

    private static ImmutableList<class_5481> nullToEmpty(@Nullable class_2561 pMessage) {
        return pMessage == null ? ImmutableList.of() : ImmutableList.of((Object)pMessage.method_30937());
    }

    public int method_29049() {
        return this.width;
    }

    public int method_29050() {
        return 20 + Math.max(this.messageLines.size(), 1) * 12;
    }

    public class_368.class_369 method_1986(class_332 pGuiGraphics, class_374 pToastComponent, long pTimeSinceLastVisible) {
        int i;
        if (this.changed) {
            this.lastChanged = pTimeSinceLastVisible;
            this.changed = false;
        }
        if ((i = this.method_29049()) == 160 && this.messageLines.size() <= 1) {
            pGuiGraphics.method_25302(BACKGROUND_SPRITE, 0, 0, 0, 64, i, this.method_29050());
        } else {
            int j = this.method_29050();
            int k = 28;
            int l = Math.min(4, j - 28);
            this.renderBackgroundRow(pGuiGraphics, pToastComponent, i, 0, 0, 28);
            for (int i1 = 28; i1 < j - l; i1 += 10) {
                this.renderBackgroundRow(pGuiGraphics, pToastComponent, i, 16, i1, Math.min(16, j - i1 - l));
            }
            this.renderBackgroundRow(pGuiGraphics, pToastComponent, i, 32 - l, j - l, l);
        }
        if (this.messageLines == null) {
            pGuiGraphics.method_51439(pToastComponent.method_1995().field_1772, this.title, 18, 12, -256, false);
        } else {
            pGuiGraphics.method_51439(pToastComponent.method_1995().field_1772, this.title, 18, 7, -256, false);
            for (int j1 = 0; j1 < this.messageLines.size(); ++j1) {
                pGuiGraphics.method_51430(pToastComponent.method_1995().field_1772, this.messageLines.get(j1), 18, 18 + j1 * 12, -1, false);
            }
        }
        return (double)(pTimeSinceLastVisible - this.lastChanged) < (double)this.id.displayTime * pToastComponent.method_48221() ? class_368.class_369.field_2210 : class_368.class_369.field_2209;
    }

    private void renderBackgroundRow(class_332 pGuiGraphics, class_374 pToastComponent, int pWidth, int p_282371_, int p_283613_, int p_282880_) {
        int i = p_282371_ == 0 ? 20 : 5;
        int j = Math.min(60, pWidth - i);
        pGuiGraphics.method_25302(BACKGROUND_SPRITE, 0, p_283613_, 0, 64 + p_282371_, i, p_282880_);
        for (int k = i; k < pWidth - j; k += 64) {
            pGuiGraphics.method_25302(BACKGROUND_SPRITE, k, p_283613_, 32, 64 + p_282371_, Math.min(64, pWidth - k - j), p_282880_);
        }
        pGuiGraphics.method_25302(BACKGROUND_SPRITE, pWidth - j, p_283613_, 160 - j, 64 + p_282371_, j, p_282880_);
    }

    public void reset(class_2561 pTitle, @Nullable class_2561 pMessage) {
        this.title = pTitle;
        this.messageLines = LongSystemToast.nullToEmpty(pMessage);
        this.changed = true;
    }

    public SystemToastIds getToken() {
        return this.id;
    }

    public static void add(class_374 pToastComponent, SystemToastIds pId, class_2561 pTitle, @Nullable class_2561 pMessage) {
        pToastComponent.method_1999((class_368)new LongSystemToast(pId, pTitle, pMessage));
    }

    public static void addOrUpdate(class_374 pToastComponent, SystemToastIds pId, class_2561 pTitle, @Nullable class_2561 pMessage) {
        LongSystemToast systemtoast = (LongSystemToast)pToastComponent.method_1997(LongSystemToast.class, (Object)pId);
        if (systemtoast == null) {
            LongSystemToast.add(pToastComponent, pId, pTitle, pMessage);
        } else {
            systemtoast.reset(pTitle, pMessage);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum SystemToastIds {
        TUTORIAL_HINT,
        NARRATOR_TOGGLE,
        WORLD_BACKUP,
        PACK_LOAD_FAILURE,
        WORLD_ACCESS_FAILURE,
        PACK_COPY_FAILURE,
        PERIODIC_NOTIFICATION,
        UNSECURE_SERVER_WARNING(10000L);

        final long displayTime;

        private SystemToastIds(long pDisplayTime) {
            this.displayTime = pDisplayTime;
        }

        private SystemToastIds() {
            this(3600000L);
        }
    }
}

