/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.animation.easing;

import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.easing.EasingFunctionArgs;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.easing.EasingType;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.easing.Memoizer;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.function.Function;

public class EasingManager {
    static Double2DoubleFunction quart = EasingManager.poly(4.0);
    static Double2DoubleFunction quint = EasingManager.poly(5.0);
    public static Function<EasingFunctionArgs, Double2DoubleFunction> getEasingFunction = Memoizer.memoize(EasingManager::getEasingFuncImpl);

    static Double2DoubleFunction getEasingFuncImpl(EasingFunctionArgs args) {
        return switch (args.easingType()) {
            case EasingType.Step -> EasingManager.in(EasingManager.step(args.arg0()));
            case EasingType.EaseInSine -> EasingManager.in(EasingManager::sin);
            case EasingType.EaseOutSine -> EasingManager.out(EasingManager::sin);
            case EasingType.EaseInOutSine -> EasingManager.inOut(EasingManager::sin);
            case EasingType.EaseInQuad -> EasingManager.in(EasingManager::quad);
            case EasingType.EaseOutQuad -> EasingManager.out(EasingManager::quad);
            case EasingType.EaseInOutQuad -> EasingManager.inOut(EasingManager::quad);
            case EasingType.EaseInCubic -> EasingManager.in(EasingManager::cubic);
            case EasingType.EaseOutCubic -> EasingManager.out(EasingManager::cubic);
            case EasingType.EaseInOutCubic -> EasingManager.inOut(EasingManager::cubic);
            case EasingType.EaseInExpo -> EasingManager.in(EasingManager::exp);
            case EasingType.EaseOutExpo -> EasingManager.out(EasingManager::exp);
            case EasingType.EaseInOutExpo -> EasingManager.inOut(EasingManager::exp);
            case EasingType.EaseInCirc -> EasingManager.in(EasingManager::circle);
            case EasingType.EaseOutCirc -> EasingManager.out(EasingManager::circle);
            case EasingType.EaseInOutCirc -> EasingManager.inOut(EasingManager::circle);
            case EasingType.EaseInQuart -> EasingManager.in(quart);
            case EasingType.EaseOutQuart -> EasingManager.out(quart);
            case EasingType.EaseInOutQuart -> EasingManager.inOut(quart);
            case EasingType.EaseInQuint -> EasingManager.in(quint);
            case EasingType.EaseOutQuint -> EasingManager.out(quint);
            case EasingType.EaseInOutQuint -> EasingManager.inOut(quint);
            case EasingType.EaseInBack -> EasingManager.in(EasingManager.back(args.arg0()));
            case EasingType.EaseOutBack -> EasingManager.out(EasingManager.back(args.arg0()));
            case EasingType.EaseInOutBack -> EasingManager.inOut(EasingManager.back(args.arg0()));
            case EasingType.EaseInElastic -> EasingManager.in(EasingManager.elastic(args.arg0()));
            case EasingType.EaseOutElastic -> EasingManager.out(EasingManager.elastic(args.arg0()));
            case EasingType.EaseInOutElastic -> EasingManager.inOut(EasingManager.elastic(args.arg0()));
            case EasingType.EaseInBounce -> EasingManager.in(EasingManager.bounce(args.arg0()));
            case EasingType.EaseOutBounce -> EasingManager.out(EasingManager.bounce(args.arg0()));
            case EasingType.EaseInOutBounce -> EasingManager.inOut(EasingManager.bounce(args.arg0()));
            default -> EasingManager.in(EasingManager::linear);
        };
    }

    static Double2DoubleFunction in(Double2DoubleFunction easing) {
        return easing;
    }

    static Double2DoubleFunction out(Double2DoubleFunction easing) {
        return t -> 1.0 - (Double)easing.apply((Object)(1.0 - t));
    }

    static Double2DoubleFunction inOut(Double2DoubleFunction easing) {
        return t -> t < 0.5 ? (Double)easing.apply((Object)(t * 2.0)) / 2.0 : 1.0 - (Double)easing.apply((Object)((1.0 - t) * 2.0)) / 2.0;
    }

    static double linear(double t) {
        return t;
    }

    static double quad(double t) {
        return t * t;
    }

    static double cubic(double t) {
        return t * t * t;
    }

    static Double2DoubleFunction poly(double n) {
        return t -> Math.pow(t, n);
    }

    static double sin(double t) {
        return 1.0 - Math.cos((float)(t * Math.PI / 2.0));
    }

    static double circle(double t) {
        return 1.0 - Math.sqrt(1.0 - t * t);
    }

    static double exp(double t) {
        return Math.pow(2.0, 10.0 * (t - 1.0));
    }

    static Double2DoubleFunction elastic(Double bounciness) {
        double p = (bounciness == null ? 1.0 : bounciness) * Math.PI;
        return t -> 1.0 - Math.pow(Math.cos((float)(t * Math.PI / 2.0)), 3.0) * Math.cos((float)(t * p));
    }

    static Double2DoubleFunction back(Double s) {
        double p = s == null ? 1.70158 : s * 1.70158;
        return t -> t * t * ((p + 1.0) * t - p);
    }

    public static Double2DoubleFunction bounce(Double s) {
        double k = s == null ? 0.5 : s;
        Double2DoubleFunction q = x -> 7.5625 * x * x;
        Double2DoubleFunction w = x -> 30.25 * k * Math.pow(x - 0.5454545454545454, 2.0) + 1.0 - k;
        Double2DoubleFunction r = x -> 121.0 * k * k * Math.pow(x - 0.8181818181818182, 2.0) + 1.0 - k * k;
        Double2DoubleFunction t = x -> 484.0 * k * k * k * Math.pow(x - 0.9545454545454546, 2.0) + 1.0 - k * k * k;
        return x -> EasingManager.min((Double)q.apply((Object)x), (Double)w.apply((Object)x), (Double)r.apply((Object)x), (Double)t.apply((Object)x));
    }

    static Double2DoubleFunction step(Double stepArg) {
        int steps = stepArg != null ? stepArg.intValue() : 2;
        double[] intervals = EasingManager.stepRange(steps);
        return t -> intervals[EasingManager.findIntervalBorderIndex(t, intervals, false)];
    }

    static double min(double a, double b, double c, double d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    static int findIntervalBorderIndex(double point, double[] intervals, boolean useRightBorder) {
        if (point < intervals[0]) {
            return 0;
        }
        if (point > intervals[intervals.length - 1]) {
            return intervals.length - 1;
        }
        int indexOfNumberToCompare = 0;
        int leftBorderIndex = 0;
        int rightBorderIndex = intervals.length - 1;
        while (rightBorderIndex - leftBorderIndex != 1) {
            indexOfNumberToCompare = leftBorderIndex + (rightBorderIndex - leftBorderIndex) / 2;
            if (point >= intervals[indexOfNumberToCompare]) {
                leftBorderIndex = indexOfNumberToCompare;
                continue;
            }
            rightBorderIndex = indexOfNumberToCompare;
        }
        return useRightBorder ? rightBorderIndex : leftBorderIndex;
    }

    static double[] stepRange(int steps) {
        double stop = 1.0;
        if (steps < 2) {
            throw new IllegalArgumentException("steps must be > 2, got:" + steps);
        }
        double stepLength = 1.0 / (double)steps;
        double[] stepArray = new double[steps];
        for (int i = 0; i < steps; ++i) {
            stepArray[i] = (double)i * stepLength;
        }
        return stepArray;
    }
}

