/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.api;

import com.github.yzqdev.skirkmod.immersivedamageindicators.ImmersiveMessagesManager;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.AnimationTimeline;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.Binding;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.easing.EasingType;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.ObfuscateMode;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.OnPoseMessage;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.OnRenderMessage;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.TextAnchor;
import com.github.yzqdev.skirkmod.immersivedamageindicators.util.ImmersiveColor;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class ImmersiveMessage {
    public class_2583 style = class_2583.field_24360;
    private class_5250 text;
    public AnimationTimeline animation;
    public ImmersiveMessage subtext;
    public ImmersiveMessage parent;
    public boolean shadow = true;
    public boolean border;
    public float yLevel = 55.0f;
    public float xLevel = 0.0f;
    public float delay = 0.0f;
    private ObfuscateMode obfuscateMode = ObfuscateMode.NONE;
    private float obfuscateSpeed = 1.0f;
    public boolean typewriter = false;
    public boolean typewriterCenterAligned = false;
    public float typewriterSpeed = 1.0f;
    public class_5250 typewriterCurrent = class_2561.method_43470((String)"");
    private float typewriterTicks;
    private int typewriterTimes = 1;
    private float obfuscateTicks;
    private int obfuscateTimes = 1;
    public TextAnchor anchor = TextAnchor.CENTER_CENTER;
    public TextAnchor align = TextAnchor.CENTER_CENTER;
    public int wrapMaxWidth = -1;
    public boolean background = false;
    public ImmersiveColor colorBackground = ImmersiveColor.BLACK.copy();
    public ImmersiveColor colorBorderTop = new ImmersiveColor(36, 1, 89, 255).mixWith(ImmersiveColor.WHITE, 0.1f);
    public ImmersiveColor colorBorderBot = new ImmersiveColor(25, 1, 53, 255);
    public float rainbow = -1.0f;
    public OnPoseMessage onPoseMessage;
    public OnRenderMessage onRenderMessage;

    private ImmersiveMessage() {
    }

    public static ImmersiveMessage builder(float duration, class_5250 text) {
        ImmersiveMessage tooltip = new ImmersiveMessage();
        tooltip.text = text;
        tooltip.style = class_2583.field_24360;
        tooltip.animation = AnimationTimeline.builder(duration);
        tooltip.animation.withYPosition(tooltip.yLevel);
        return tooltip;
    }

    public void render(class_332 graphics, float deltaTicks) {
        this.render(graphics, deltaTicks, 0);
    }

    private void render(class_332 graphics, float deltaTicks, int depth) {
        this.tick(deltaTicks);
        this.animation.advancePlayhead(deltaTicks / 20.0f);
        if (depth != 0 || !(this.animation.getCurrent() >= this.animation.duration)) {
            ImmersiveMessagesManager.getRenderer().render(this, graphics, deltaTicks);
            if (this.subtext != null) {
                this.subtext.render(graphics, deltaTicks, depth + 1);
            }
        }
    }

    public class_5250 getText() {
        return this.typewriter ? this.typewriterCurrent.method_27696(this.style) : this.text.method_27696(this.style);
    }

    public class_5250 getRawText() {
        return this.text.method_27696(this.style);
    }

    public ImmersiveMessage anchor(TextAnchor anchor) {
        this.anchor = anchor;
        return this;
    }

    public ImmersiveMessage y(float ylevel) {
        this.yLevel = ylevel;
        this.animation.withYPosition(ylevel);
        return this;
    }

    public ImmersiveMessage x(float xlevel) {
        this.xLevel = xlevel;
        this.animation.withXPosition(xlevel);
        return this;
    }

    public ImmersiveMessage size(float size) {
        this.animation.withSize(size);
        return this;
    }

    public ImmersiveMessage fadeIn() {
        return this.fadeIn(1.0f);
    }

    public ImmersiveMessage fadeIn(float duration) {
        this.animation.transition(Binding.Alpha, this.delay, this.delay + duration, 0.0f, 1.0f, EasingType.EaseOutSine);
        return this;
    }

    public ImmersiveMessage fadeOut() {
        return this.fadeOut(1.0f);
    }

    public ImmersiveMessage fadeOut(float duration) {
        this.animation.fadeout(duration);
        return this;
    }

    public ImmersiveMessage slideUp() {
        return this.slideUp(1.0f);
    }

    public ImmersiveMessage slideUp(float duration) {
        this.animation.transition(Binding.yPos, this.delay, this.delay + duration, this.yLevel + 50.0f, this.yLevel, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage animation(Consumer<AnimationTimeline> animationBuilder) {
        animationBuilder.accept(this.animation);
        return this;
    }

    public void tick(float delta) {
        this.tickObfuscation(delta);
        this.tickTypewriter(delta);
    }

    private void tickTypewriter(float delta) {
        String str = this.text.getString();
        if (this.typewriterTimes <= str.length()) {
            this.typewriterTicks += delta;
            if (this.typewriterTicks > (float)this.typewriterTimes * (1.0f / this.typewriterSpeed)) {
                ++this.typewriterTimes;
                String current = str.substring(0, Math.min(str.length(), this.typewriterTimes));
                this.typewriterCurrent = class_2561.method_43470((String)current);
                char lastChar = current.charAt(current.length() - 1);
                if (lastChar == ',') {
                    this.typewriterTicks -= 3.0f / this.typewriterSpeed;
                } else if (lastChar == '.') {
                    this.typewriterTicks -= 5.0f * (1.0f / this.typewriterSpeed);
                } else if (lastChar == '\u00a7') {
                    this.typewriterTicks -= 5.0f * (1.0f / this.typewriterSpeed);
                } else if (lastChar == ' ') {
                    this.typewriterTicks += 1.0f / this.typewriterSpeed;
                    ++this.typewriterTimes;
                    this.typewriterCurrent = class_2561.method_43470((String)str.substring(0, Math.min(str.length(), this.typewriterTimes)));
                }
            }
        }
    }

    private void tickObfuscation(float delta) {
        this.obfuscateTicks += delta;
        if (this.obfuscateTicks > (float)this.obfuscateTimes * (1.0f / this.obfuscateSpeed)) {
            String str = this.text.getString();
            ++this.obfuscateTimes;
            switch (this.obfuscateMode) {
                case LEFT: {
                    this.text = class_2561.method_43470((String)str.replaceFirst("\u00a7k", ""));
                    break;
                }
                case RIGHT: {
                    int index = str.lastIndexOf("\u00a7k");
                    if (index == -1) break;
                    String var10 = str.substring(0, index);
                    this.text = class_2561.method_43470((String)(var10 + str.substring(index + 2)));
                    break;
                }
                case CENTER: {
                    int index = this.getClosestIndexToCenter(str, "\u00a7k");
                    if (index == -1) break;
                    String var9 = str.substring(0, index);
                    this.text = class_2561.method_43470((String)(var9 + str.substring(index + 2)));
                    break;
                }
                case RANDOM: {
                    ArrayList<Integer> occurrences = new ArrayList<Integer>();
                    for (int i = 0; i <= str.length() - 2; ++i) {
                        if (!str.startsWith("\u00a7k", i)) continue;
                        occurrences.add(i);
                    }
                    if (occurrences.isEmpty()) break;
                    Random rand = new Random();
                    int index = (Integer)occurrences.get(rand.nextInt(occurrences.size()));
                    String var10001 = str.substring(0, index);
                    this.text = class_2561.method_43470((String)(var10001 + str.substring(index + 2)));
                }
            }
        }
    }

    private int getClosestIndexToCenter(String str, String target) {
        int centerIndex = str.length() / 2;
        int closestIndex = -1;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i <= str.length() - target.length(); ++i) {
            int distanceFromCenter;
            if (!str.substring(i, i + target.length()).equals(target) || (distanceFromCenter = Math.abs(i - centerIndex)) >= minDistance) continue;
            closestIndex = i;
            minDistance = distanceFromCenter;
        }
        return closestIndex;
    }
}

