/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.api;

import org.joml.Vector2f;
import org.joml.Vector2i;

public enum TextAnchor {
    CENTER_CENTER,
    CENTER_LEFT,
    CENTER_RIGHT,
    BOTTOM_CENTER,
    BOTTOM_LEFT,
    BOTTOM_RIGHT,
    TOP_CENTER,
    TOP_LEFT,
    TOP_RIGHT;

    private static TextAnchor[] cachedValues;

    public Vector2f getOffset(float guiWidth, float guiHeight, float width, float height) {
        return switch (this.ordinal()) {
            case 0 -> new Vector2f(guiWidth - width, guiHeight - height);
            case 1 -> new Vector2f(0.0f, guiHeight - height);
            case 2 -> new Vector2f(guiWidth * 2.0f - width * 2.0f, guiHeight - height);
            case 3 -> new Vector2f(guiWidth - width, guiHeight * 2.0f - height * 2.0f);
            case 4 -> new Vector2f(0.0f, guiHeight * 2.0f - height * 2.0f);
            case 5 -> new Vector2f(guiWidth * 2.0f - width * 2.0f, guiHeight * 2.0f - height * 2.0f);
            case 6 -> new Vector2f(guiWidth - width, 0.0f);
            case 7 -> new Vector2f(0.0f, 0.0f);
            case 8 -> new Vector2f(guiWidth * 2.0f - width * 2.0f, 0.0f);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Vector2f getAlign(float width, float height) {
        return switch (this.ordinal()) {
            case 0 -> new Vector2f(0.0f, 0.0f);
            case 1 -> new Vector2f(-width, 0.0f);
            case 2 -> new Vector2f(width, 0.0f);
            case 3 -> new Vector2f(0.0f, height);
            case 4 -> new Vector2f(-width, height);
            case 5 -> new Vector2f(width, height);
            case 6 -> new Vector2f(0.0f, -height);
            case 7 -> new Vector2f(-width, -height);
            case 8 -> new Vector2f(width, -height);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Vector2i getNormalized() {
        return switch (this.ordinal()) {
            case 0 -> new Vector2i(0, 0);
            case 1 -> new Vector2i(-1, 0);
            case 2 -> new Vector2i(1, 0);
            case 3 -> new Vector2i(0, 1);
            case 4 -> new Vector2i(-1, 1);
            case 5 -> new Vector2i(1, 1);
            case 6 -> new Vector2i(0, -1);
            case 7 -> new Vector2i(-1, -1);
            case 8 -> new Vector2i(1, -1);
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

