/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.util;

import com.github.yzqdev.skirkmod.immersivedamageindicators.api.ImmersiveMessage;
import com.github.yzqdev.skirkmod.immersivedamageindicators.util.AnimationUtil;
import com.github.yzqdev.skirkmod.immersivedamageindicators.util.ImmersiveColor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import org.joml.Vector2i;
import org.joml.Vector3i;

public class RenderUtil {
    private static double totalTicks = 0.0;

    public static void drawBackground(ImmersiveMessage tooltip, class_332 graphics, Vector3i size, Vector2i bgOffset, float deltaTicks) {
        ImmersiveColor colorBorderBot;
        ImmersiveColor colorBorderTop;
        int width = size.x;
        int height = size.y;
        int titleLinesCount = size.z;
        int xMaxL = -3;
        int xMinL = -4;
        int xMinR = width + 3;
        int xMaxR = width + 4;
        int yMaxT = -4;
        int yMinT = -5;
        int yMaxB = height + 4;
        int yMinB = height + 3;
        float fade = (float)class_5253.class_5254.method_27762((int)tooltip.animation.getColor()) / 255.0f;
        ImmersiveColor colorBackground = tooltip.colorBackground.copy().scaleAlpha(0.75f * fade);
        if (tooltip.rainbow >= 0.0f) {
            colorBorderTop = ImmersiveColor.rainbowColor((int)(totalTicks += (double)(deltaTicks * tooltip.rainbow))).scaleAlpha(0.75f * fade);
            colorBorderBot = ImmersiveColor.rainbowColor((int)totalTicks).scaleAlpha(0.75f * fade);
        } else {
            colorBorderTop = tooltip.colorBorderTop.copy().scaleAlpha(0.75f * fade);
            colorBorderBot = tooltip.colorBorderBot.copy().scaleAlpha(0.75f * fade);
        }
        int backgroundColor = colorBackground.getRGB();
        int borderColorStart = colorBorderTop.getRGB();
        int borderColorEnd = colorBorderBot.getRGB();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)bgOffset.x, (float)bgOffset.y, -5.0f);
        AnimationUtil.applyPose(tooltip.animation, graphics, bgOffset, tooltip.anchor, tooltip.align, size.x, size.y);
        graphics.method_25296(xMaxL, yMinT, xMinR, yMaxT, backgroundColor, backgroundColor);
        graphics.method_25296(xMaxL, yMinB, xMinR, yMaxB, backgroundColor, backgroundColor);
        graphics.method_25296(xMaxL, yMaxT, xMinR, yMinB, backgroundColor, backgroundColor);
        graphics.method_25296(xMinL, yMaxT, xMaxL, yMinB, backgroundColor, backgroundColor);
        graphics.method_25296(xMinR, yMaxT, xMaxR, yMinB, backgroundColor, backgroundColor);
        graphics.method_25296(xMaxL, yMaxT + 1, xMaxL + 1, yMinB - 1, borderColorStart, borderColorEnd);
        graphics.method_25296(xMinR - 1, yMaxT + 1, xMinR, yMinB - 1, borderColorStart, borderColorEnd);
        graphics.method_25296(xMaxL, yMaxT, xMinR, yMaxT + 1, borderColorStart, borderColorStart);
        graphics.method_25296(xMaxL, yMinB - 1, xMinR, yMinB, borderColorEnd, borderColorEnd);
        graphics.method_51448().method_22909();
    }

    public static Vector3i wrapText(List<class_5348> textLines, int maxTextWidth, Function<class_5348, Integer> widthLookup) {
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        class_327 font = mc.field_1772;
        int tooltipTextWidth = 0;
        for (class_5348 textLine : textLines) {
            int textLineWidth = widthLookup.apply(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        int titleLinesCount = 1;
        if (maxTextWidth >= 0) {
            if (tooltipTextWidth > screenWidth / 2) {
                tooltipTextWidth = screenWidth / 2;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<class_5348> wrappedTextLines = new ArrayList<class_5348>();
            for (int i = 0; i < textLines.size(); ++i) {
                class_5348 textLine = textLines.get(i);
                List wrappedLine = font.method_27527().method_27495(textLine, tooltipTextWidth, class_2583.field_24360);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (class_5348 line : wrappedLine) {
                    int lineWidth = widthLookup.apply(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines.clear();
            textLines.addAll(wrappedTextLines);
        }
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        return new Vector3i(tooltipTextWidth, tooltipHeight, titleLinesCount);
    }
}

