/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.magmacore.thirdparty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;

public class CustomBiomeCompatibility {
    private static final Map<String, List<String>> defaultBiomeToCustomBiomes = new HashMap<String, List<String>>();

    private CustomBiomeCompatibility() {
    }

    public static void shutdown() {
        defaultBiomeToCustomBiomes.clear();
    }

    public static void initializeMappings() {
        String[] lines;
        String mappings = "// Iris - The Dimensions Engine - Overworld Pack (default)\n    - iris:frozen_peak = minecraft:frozen_peaks\n    - iris:frozen_mountain = minecraft:frozen_peaks\n    - iris:frozen_mountaincliff = minecraft:frozen_peaks\n    - iris:frozen_mountain_middle = minecraft:frozen_peaks\n    - iris:frozen_hills = minecraft:snowy_slopes\n    - iris:frozen_pine_hills = minecraft:snowy_slopes\n    - iris:frozen_pine_plains = minecraft:snowy_slopes\n    - iris:frozen_pines = minecraft:snowy_taiga\n    - iris:frozen_plains = minecraft:snowy_plains\n    - iris:frozen_redwood_forest = minecraft:snowy_taiga\n    - iris:frozen_spruce_hills = minecraft:snowy_slopes\n    - iris:frozen_spruce_plains = minecraft:snowy_plains\n    - iris:frozen_river_ice = minecraft:frozen_river\n    - iris:frozen_beach = minecraft:snowy_beach\n    - iris:frozen_vander = minecraft:snowy_plains\n    - iris:hot_beach = minecraft:beach\n    - iris:mushroom_crimson_forest = minecraft:cherry_grove\n    - iris:mushroom_forest = minecraft:forest\n    - iris:mushroom_hills = minecraft:windswept_hills\n    - iris:mushroom_plains = minecraft:mushroom_fields\n    - iris:mushroom_warped_forest = minecraft:forest\n    - iris:mushroom_beach = minecraft:beach\n    - iris:savanna_acacia_denmyre = nothing\n    - iris:savanna_cliffs = minecraft:badlands\n    - iris:savanna_forest = minecraft:taiga\n    - iris:savanna_plateau = minecraft:savanna_plateau\n    - iris:savanna = minecraft:savanna\n    - iris:swamp_cambian_drift = minecraft:mangrove_swamp\n    - iris:swamp_marsh_rotten = minecraft:swamp\n    - iris:k530forestswamp = minecraft:mangrove_swamp\n    - iris:k530mangroveswamp = minecraft:mangrove_swamp\n    - iris:k530puddle = minecraft:swamp\n    - iris:island = nothing\n    - iris:longtree_forest = minecraft:old_growth_pine_taiga\n    - iris:tropical_highlands = minecraft:badlands\n    - iris:tropical_mountain_extreme = minecraft:eroded_badlands\n\n    // terra\n    - terra:overworld/overworld/carving_land = minecraft:eroded_badlands\n    - terra:overworld/overworld/carving_ocean = minecraft:deep_ocean\n    - terra:overworld/overworld/cave = minecraft:deep_dark\n    - terra:overworld/overworld/cold_deep_ocean = minecraft:cold_ocean\n    - terra:overworld/overworld/frozen_deep_ocean = minecraft:deep_frozen_ocean\n    - terra:overworld/overworld/iceberg_ocean = minecraft:deep_frozen_ocean\n    - terra:overworld/overworld/subtropical_deep_ocean = minecraft:deep_lukewarm_ocean\n    - terra:overworld/overworld/deep_ocean = minecraft:deep_lukewarm_ocean\n    - terra:overworld/overworld/tropical_deep_ocean = minecraft:deep_lukewarm_ocean\n    - terra:overworld/overworld/cold_ocean = minecraft:cold_ocean\n    - terra:overworld/overworld/frozen_ocean = minecraft:frozen_ocean\n    - terra:overworld/overworld/frozen_marsh = minecraft:frozen_river\n    - terra:overworld/overworld/frozen_river = minecraft:frozen_river\n    - terra:overworld/overworld/deep_dark = minecraft:deep_dark\n    - terra:overworld/overworld/dripstone_caves = minecraft:deep_dark\n    - terra:overworld/overworld/lush_caves = minecraft:lush_caves\n    - terra:overworld/overworld/autumnal_flats = minecraft:meadow\n    - terra:overworld/overworld/birch_flats = minecraft:birch_forest\n    - terra:overworld/overworld/taiga_flats = minecraft:taiga\n    - terra:overworld/overworld/yellowstone = minecraft:meadow\n    - terra:overworld/overworld/frozen_beach = minecraft:frozen_ocean\n    - terra:overworld/overworld/snowy_meadow = minecraft:snowy_plains\n    - terra:overworld/overworld/snowy_plains = minecraft:snowy_plains\n    - terra:overworld/overworld/tundra_plains = minecraft:badlands\n    - terra:overworld/overworld/evergreen_flats = minecraft:meadow\n    - terra:overworld/overworld/flowering_flats = minecraft:meadow\n    - terra:overworld/overworld/oak_savanna = minecraft:savanna\n    - terra:overworld/overworld/beach = minecraft:beach\n    - terra:overworld/overworld/shale_beach = minecraft:beach\n    - terra:overworld/overworld/shrub_beach = minecraft:beach\n    - terra:overworld/overworld/eucalyptus_forest = minecraft:forest\n    - terra:overworld/overworld/plains = minecraft:meadow\n    - terra:overworld/overworld/prairie = minecraft:savanna\n    - terra:overworld/overworld/steppe = minecraft:savanna_plateau\n    - terra:overworld/overworld/sunflower_plains = minecraft:meadow\n    - terra:overworld/overworld/forest_flats = minecraft:forest\n    - terra:overworld/overworld/rocky_archipelago = minecraft:stony_peaks\n    - terra:overworld/overworld/autumnal_forest_hills = minecraft:windswept_hills\n    - terra:overworld/overworld/birch_forest_hills = minecraft:windswept_hills\n    - terra:overworld/overworld/flowering_autumnal_forest_hills = minecraft:windswept_hills\n    - terra:overworld/overworld/redwood_forest_hills = minecraft:windswept_hills\n    - terra:overworld/overworld/taiga_hills = minecraft:windswept_forest\n    - terra:overworld/overworld/tundra_hills = minecraft:windswept_gravelly_hills\n    - terra:overworld/overworld/frozen_archipelago = minecraft:frozen_peaks\n    - terra:overworld/overworld/xerophytic_forest_hills = minecraft:windswept_forest\n    - terra:overworld/overworld/rainforest_hills = minecraft:windswept_forest\n    - terra:overworld/overworld/moorland = minecraft:windswept_forest\n    - terra:overworld/overworld/evergreen_forest_hills = minecraft:windswept_forest\n    - terra:overworld/overworld/flowering_forest_hills = minecraft:windswept_forest\n    - terra:overworld/overworld/archipelago = minecraft:windswept_hills\n    - terra:overworld/overworld/shrubland = minecraft:windswept_forest\n    - terra:overworld/overworld/dark_forest_hills = minecraft:windswept_forest\n    - terra:overworld/overworld/forest_hills = minecraft:windswept_forest\n    - terra:overworld/overworld/arid_spikes = minecraft:wooded_badlands\n    - terra:overworld/overworld/xeric_hills = minecraft:wooded_badlands\n    - terra:overworld/overworld/sandstone_archipelago = minecraft:wooded_badlands\n    - terra:overworld/overworld/bamboo_jungle_hills = minecraft:windswept_forest\n    - terra:overworld/overworld/jungle_hills = minecraft:windswept_forest\n    - terra:overworld/overworld/chaparral = minecraft:windswept_savanna\n    - terra:overworld/overworld/grass_savanna_hills = minecraft:windswept_savanna\n    - terra:overworld/overworld/savanna_hills = minecraft:windswept_savanna\n    - terra:overworld/overworld/rocky_sea_arches = minecraft:ocean\n    - terra:overworld/overworld/rocky_sea_caves = minecraft:ocean\n    - terra:overworld/overworld/snowy_sea_arches = minecraft:cold_ocean\n    - terra:overworld/overworld/snowy_sea_caves = minecraft:cold_ocean\n    - terra:overworld/overworld/snowy_terraced_mountains = minecraft:snowy_slopes\n    - terra:overworld/overworld/snowy_terraced_mountains_river = minecraft:snowy_beach\n    - terra:overworld/overworld/lush_sea_caves = minecraft:lush_caves\n    - terra:overworld/overworld/large_monsoon_mountains = minecraft:jagged_peaks\n    - terra:overworld/overworld/temperate_alpha_mountains = minecraft:jagged_peaks\n    - terra:overworld/overworld/temperate_sea_arches = minecraft:ocean\n    - terra:overworld/overworld/dry_temperate_mountains = minecraft:eroded_badlands\n    - terra:overworld/overworld/dry_temperate_mountains_river = minecraft:river\n    - terra:overworld/overworld/dry_temperate_white_mountains = minecraft:snowy_slopes\n    - terra:overworld/overworld/dry_temperate_white_mountains_river = minecraft:river\n    - terra:overworld/overworld/cracked_badlands_plateau = minecraft:jagged_peaks\n    - terra:overworld/overworld/terracotta_sea_arches = minecraft:ocean\n    - terra:overworld/overworld/terracotta_sea_caves = minecraft:ocean\n    - terra:overworld/overworld/bamboo_jungle_mountains = minecraft:wooded_badlands\n    - terra:overworld/overworld/jungle_mountains = minecraft:wooded_badlands\n    - terra:overworld/overworld/dry_wild_highlands = minecraft:eroded_badlands\n    - terra:overworld/overworld/cerros_de_mavecure = nothing\n    - terra:overworld/overworld/wild_highlands = minecraft:windswept_gravelly_hills\n    - terra:overworld/overworld/rocky_wetlands = minecraft:windswept_gravelly_hills\n    - terra:overworld/overworld/autumnal_forest = minecraft:windswept_savanna\n    - terra:overworld/overworld/birch_forest = minecraft:birch_forest\n    - terra:overworld/overworld/taiga = minecraft:taiga\n    - terra:overworld/overworld/frozen_wetlands = minecraft:frozen_peaks\n    - terra:overworld/overworld/ice_spikes = minecraft:ice_spikes\n    - terra:overworld/overworld/tundra_midlands = minecraft:badlands\n    - terra:overworld/overworld/xerophytic_forest = minecraft:forest\n    - terra:overworld/overworld/rainforest = minecraft:jungle\n    - terra:overworld/overworld/evergreen_forest = minecraft:old_growth_pine_taiga\n    - terra:overworld/overworld/flowering_forest = minecraft:old_growth_birch_forest\n    - terra:overworld/overworld/wetlands = minecraft:beach\n    - terra:overworld/overworld/dark_forest = minecraft:dark_forest\n    - terra:overworld/overworld/forest = minecraft:forest\n    - terra:overworld/overworld/wooded_buttes = minecraft:forest\n    - terra:overworld/overworld/badlands_buttes = minecraft:badlands\n    - terra:overworld/overworld/desert = minecraft:desert\n    - terra:overworld/overworld/desert_spikes = minecraft:desert\n    - terra:overworld/overworld/desert_spikes_gold = minecraft:desert\n    - terra:overworld/overworld/eroded_badlands_buttes = minecraft:eroded_badlands\n    - terra:overworld/overworld/rocky_desert = minecraft:badlands\n    - terra:overworld/overworld/sandstone_wetlands = minecraft:badlands\n    - terra:overworld/overworld/bamboo_jungle = minecraft:jungle\n    - terra:overworld/overworld/jungle = minecraft:jungle\n    - terra:overworld/overworld/low_chaparral = nothing\n    - terra:overworld/overworld/xeric_low_hills = minecraft:windswept_hills\n    - terra:overworld/overworld/grass_savanna_low_hills = minecraft:windswept_savanna\n    - terra:overworld/overworld/savanna_low_hills = minecraft:windswept_savanna\n    - terra:overworld/overworld/mountains = minecraft:windswept_hills\n    - terra:overworld/overworld/mountains_river = minecraft:windswept_hills\n    - terra:overworld/overworld/snowy_eroded_terraced_mountains = minecraft:snowy_slopes\n    - terra:overworld/overworld/snowy_eroded_terraced_mountains_river = minecraft:snowy_beach\n    - terra:overworld/overworld/snowy_mountains = minecraft:snowy_slopes\n    - terra:overworld/overworld/snowy_mountains_river = minecraft:snowy_beach\n    - terra:overworld/overworld/arid_highlands = minecraft:jagged_peaks\n    - terra:overworld/overworld/dry_rocky_bumpy_mountains = minecraft:windswept_gravelly_hills\n    - terra:overworld/overworld/monsoon_mountains = minecraft:windswept_gravelly_hills\n    - terra:overworld/overworld/rocky_bumpy_mountains = minecraft:windswept_gravelly_hills\n    - terra:overworld/overworld/evergreen_overhangs = minecraft:windswept_forest\n    - terra:overworld/overworld/wild_bumpy_mountains = minecraft:windswept_hills\n    - terra:overworld/overworld/highlands = minecraft:windswept_hills\n    - terra:overworld/overworld/sakura_mountains = minecraft:cherry_grove\n    - terra:overworld/overworld/temperate_mountains = minecraft:savanna_plateau\n    - terra:overworld/overworld/temperate_mountains_river = minecraft:savanna_plateau\n    - terra:overworld/overworld/arid_highlands = minecraft:savanna_plateau\n    - terra:overworld/overworld/badlands_mountains = minecraft:badlands\n    - terra:overworld/overworld/badlands_mountains_river = minecraft:badlands\n    - terra:overworld/overworld/desert_pillars = minecraft:desert\n    - terra:overworld/overworld/xeric_mountains = minecraft:windswept_hills\n    - terra:overworld/overworld/xeric_mountains_river = minecraft:windswept_hills\n    - terra:overworld/overworld/overgrown_cliffs = minecraft:windswept_forest\n    - terra:overworld/overworld/savanna_overhangs = minecraft:windswept_forest\n    - terra:overworld/overworld/mushroom_coast = minecraft:mushroom_fields\n    - terra:overworld/overworld/mushroom_fields = minecraft:mushroom_fields\n    - terra:overworld/overworld/mushroom_hills = minecraft:mushroom_fields\n    - terra:overworld/overworld/mushroom_mountains = minecraft:mushroom_fields\n    - terra:overworld/overworld/active_volcano_base = minecraft:eroded_badlands\n    - terra:overworld/overworld/active_volcano_base_edge = minecraft:badlands\n    - terra:overworld/overworld/active_volcano_pit = minecraft:eroded_badlands\n    - terra:overworld/overworld/active_volcano_pit_edge = minecraft:badlands\n    - terra:overworld/overworld/caldera_volcano_base = minecraft:eroded_badlands\n    - terra:overworld/overworld/caldera_volcano_base_edge = minecraft:badlands\n    - terra:overworld/overworld/caldera_volcano_pit = minecraft:eroded_badlands\n    - terra:overworld/overworld/caldera_volcano_pit_edge = minecraft:badlands\n    - terra:origen/origen/arid_arboretum = minecraft:wooded_badlands\n    - terra:origen/origen/badlands_balconies = minecraft:badlands\n    - terra:origen/origen/barren_tilted = minecraft:eroded_badlands\n    - terra:origen/origen/black_forest = minecraft:dark_forest\n    - terra:origen/origen/broadleaf_forest = minecraft:forest\n    - terra:origen/origen/canyon_frozen = minecraft:snowy_slopes\n    - terra:origen/origen/carving_creaks = minecraft:eroded_badlands\n    - terra:origen/origen/cave_jungle = minecraft:lush_caves\n    - terra:origen/origen/coast_cold_a = minecraft:cold_ocean\n    - terra:origen/origen/coast_cold_b = minecraft:cold_ocean\n    - terra:origen/origen/coast_medium_a = minecraft:beach\n    - terra:origen/origen/coast_medium_b = minecraft:beach\n    - terra:origen/origen/coast_warm_a = minecraft:lukewarm_ocean\n    - terra:origen/origen/coast_warm_b = minecraft:lukewarm_ocean\n    - terra:origen/origen/cold_steppe = minecraft:snowy_taiga\n    - terra:origen/origen/desert = minecraft:desert\n    - terra:origen/origen/desert_spikes = minecraft:desert\n    - terra:origen/origen/dinosaurs = minecraft:savanna_plateau\n    - terra:origen/origen/dripstone_caves = minecraft:dripstone_caves\n    - terra:origen/origen/flowering_forest = minecraft:flower_forest\n    - terra:origen/origen/frosty_fingers = minecraft:snowy_slopes\n    - terra:origen/origen/frozen_archipelago = minecraft:frozen_ocean\n    - terra:origen/origen/frozen_beach = minecraft:frozen_ocean\n    - terra:origen/origen/frozen_fungi = minecraft:snowy_taiga\n    - terra:origen/origen/frozen_vistas = minecraft:snowy_plains\n    - terra:origen/origen/gloomy_gorge = minecraft:old_growth_pine_taiga\n    - terra:origen/origen/ice_spikes = minecraft:ice_spikes\n    - terra:origen/origen/inferno_isle = minecraft:nether_wastes\n    - terra:origen/origen/jungle_vistas = minecraft:jungle\n    - terra:origen/origen/land_cold_a = minecraft:snowy_plains\n    - terra:origen/origen/land_cold_b = minecraft:snowy_taiga\n    - terra:origen/origen/land_medium_a = minecraft:plains\n    - terra:origen/origen/land_medium_b = minecraft:savanna\n    - terra:origen/origen/land_warm_a = minecraft:savanna\n    - terra:origen/origen/land_warm_b = minecraft:desert\n    - terra:origen/origen/lush_caves = minecraft:lush_caves\n    - terra:origen/origen/lush_loops = minecraft:meadow\n    - terra:origen/origen/marsh = minecraft:swamp\n    - terra:origen/origen/mesa_monuments = minecraft:badlands\n    - terra:origen/origen/murky_marshlands = minecraft:mangrove_swamp\n    - terra:origen/origen/mushroom_coast = minecraft:mushroom_fields\n    - terra:origen/origen/mushroom_fields = minecraft:mushroom_fields\n    - terra:origen/origen/overgrown_cliffs = minecraft:windswept_forest\n    - terra:origen/origen/pillow_plains_inner = minecraft:plains\n    - terra:origen/origen/pillow_plains_middle = minecraft:plains\n    - terra:origen/origen/pillow_plains_outer = minecraft:meadow\n    - terra:origen/origen/plateao_inner = minecraft:stony_peaks\n    - terra:origen/origen/plateao_middle = minecraft:stony_peaks\n    - terra:origen/origen/plateao_outer = minecraft:stony_peaks\n    - terra:origen/origen/redwood_forests = minecraft:old_growth_pine_taiga\n    - terra:origen/origen/rocky_refuge = minecraft:stony_peaks\n    - terra:origen/origen/salt_flats = minecraft:desert\n    - terra:origen/origen/scarlet_sanctuary = minecraft:crimson_forest\n    - terra:origen/origen/secluded_valley = minecraft:sparse_jungle\n    - terra:origen/origen/sinkhole_forest = minecraft:old_growth_birch_forest\n    - terra:origen/origen/sinkhole_frozen = minecraft:snowy_taiga\n    - terra:origen/origen/sinkhole_jungle = minecraft:jungle\n    - terra:origen/origen/sinkhole_outer = minecraft:sparse_jungle\n    - terra:origen/origen/snowy_meadow = minecraft:snowy_plains\n    - terra:origen/origen/snowy_plains = minecraft:snowy_plains\n    - terra:origen/origen/snowy_sea_caves = minecraft:cold_ocean\n    - terra:origen/origen/snowy_spires = minecraft:snowy_slopes\n    - terra:origen/origen/stone_savanna = minecraft:savanna_plateau\n    - terra:origen/origen/swamp = minecraft:swamp\n    - terra:origen/origen/terracotta_tombs = minecraft:badlands\n    - terra:origen/origen/tundra = minecraft:snowy_taiga\n    - terra:origen/origen/tundra_tracks = minecraft:snowy_plains\n    - terra:origen/origen/variant_c = minecraft:plains\n    - terra:origen/origen/variant_f = minecraft:plains\n    - terra:origen/origen/variant_g = minecraft:plains\n    - terra:origen/origen/variant_h = minecraft:plains\n    - terra:origen/origen/verdant_valleys = minecraft:meadow\n    - terra:origen/origen/vertical_vistas = minecraft:stony_peaks\n    - terra:origen/origen/white_wallows = minecraft:snowy_slopes\n\n    // terraform generator\n    - terraformgenerator:snowy_mountains = minecraft:frozen_peaks\n    - terraformgenerator:birch_mountains = minecraft:windswept_forest\n    - terraformgenerator:rocky_mountains = minecraft:stony_peaks\n    - terraformgenerator:forested_mountains = minecraft:stony_peaks\n    - terraformgenerator:shattered_savanna = minecraft:savanna\n    - terraformgenerator:painted_hills = nothing\n    - terraformgenerator:badlands_canyon = minecraft:badlands\n    - terraformgenerator:desert_mountains = nothing\n    - terraformgenerator:jagged_peaks = minecraft:jagged_peaks\n    - terraformgenerator:cold_jagged_peaks = minecraft:jagged_peaks\n    - terraformgenerator:transition_jagged_peaks = minecraft:jagged_peaks\n    - terraformgenerator:forested_peaks = minecraft:stony_peaks\n    - terraformgenerator:shattered_savanna_peak = minecraft:savanna_plateau\n    - terraformgenerator:badlands_canyon_peak = minecraft:eroded_badlands\n    - terraformgenerator:ocean = minecraft:ocean\n    - terraformgenerator:black_ocean = minecraft:ocean\n    - terraformgenerator:cold_ocean = minecraft:cold_ocean\n    - terraformgenerator:frozen_ocean = minecraft:frozen_ocean\n    - terraformgenerator:warm_ocean = minecraft:warm_ocean\n    - terraformgenerator:humid_ocean = minecraft:lukewarm_ocean\n    - terraformgenerator:dry_ocean = minecraft:ocean\n    - terraformgenerator:coral_reef_ocean = minecraft:deep_ocean\n    - terraformgenerator:river = minecraft:river\n    - terraformgenerator:bog_river = minecraft:river\n    - terraformgenerator:cherry_grove_river = minecraft:river\n    - terraformgenerator:scarlet_forest_river = minecraft:river\n    - terraformgenerator:jungle_river = minecraft:river\n    - terraformgenerator:frozen_river = minecraft:frozen_river\n    - terraformgenerator:dark_forest_river = minecraft:river\n    - terraformgenerator:desert_river = minecraft:river\n    - terraformgenerator:badlands_river = minecraft:river\n    - terraformgenerator:deep_ocean = minecraft:deep_ocean\n    - terraformgenerator:deep_cold_ocean = minecraft:deep_cold_ocean\n    - terraformgenerator:deep_black_ocean = minecraft:deep_ocean\n    - terraformgenerator:deep_frozen_ocean = minecraft:deep_frozen_ocean\n    - terraformgenerator:deep_warm_ocean = minecraft:deep_warm_ocean\n    - terraformgenerator:deep_humid_ocean = minecraft:deep_lukewarm_ocean\n    - terraformgenerator:deep_dry_ocean = minecraft:deep_ocean\n    - terraformgenerator:deep_lukewarm_ocean = minecraft:deep_lukewarm_ocean\n    - terraformgenerator:mushroom_islands = minecraft:mushroom_fields\n    - terraformgenerator:plains = minecraft:plains\n    - terraformgenerator:elevated_plains = minecraft:windswept_hills\n    - terraformgenerator:dodge_petrified_cliffs = nothing\n    - terraformgenerator:arched_cliffs = nothing\n    - terraformgenerator:savanna_muddy_bog_forest = nothing\n    - terraformgenerator:jungle = minecraft:jungle\n    - terraformgenerator:bamboo_forest = minecraft:bamboo_jungle\n    - terraformgenerator:desert_badlands = minecraft:desert\n    - terraformgenerator:eroded_plains = minecraft:plains\n    - terraformgenerator:scarlet_forest = nothing\n    - terraformgenerator:cherry_grove = minecraft:cherry_grove\n    - terraformgenerator:taiga = minecraft:taiga\n    - terraformgenerator:snowy_taiga = minecraft:snowy_taiga\n    - terraformgenerator:snowy_wasteland = minecraft:ice_spikes\n    - terraformgenerator:ice_spikes = minecraft:ice_spikes\n    - terraformgenerator:dark_forest = minecraft:dark_forest\n    - terraformgenerator:swamp = minecraft:swamp\n    - terraformgenerator:mangrove = minecraft:mangrove_swamp\n    - terraformgenerator:sandy_beach = minecraft:beach\n    - terraformgenerator:bog_beach = nothing\n    - terraformgenerator:dark_forest_beach = minecraft:beach\n    - terraformgenerator:badlands_beach = minecraft:beach\n    - terraformgenerator:mushroom_beach = minecraft:beach\n    - terraformgenerator:black_ocean_beach = minecraft:beach\n    - terraformgenerator:rocky_beach = minecraft:stony_shore\n    - terraformgenerator:icy_beach = minecraft:snowy_beach\n    - terraformgenerator:mud_flats = nothing\n    - terraformgenerator:cherry_grove_beach = minecraft:beach\n    - terraformgenerator:scarlet_forest_beach = minecraft:beach\n\n\n    // terralith\n    - terralith:alpha_islands = minecraft:plains\n    - terralith:alpha_islands_winter = minecraft:snowy_plains\n    - terralith:alpine_grove = minecraft:grove\n    - terralith:alpine_highlands = minecraft:plains\n    - terralith:amethyst_canyon = minecraft:forest\n    - terralith:amethyst_rainforest = minecraft:jungle\n    - terralith:ancient_sands = minecraft:desert\n    - terralith:arid_highlands = minecraft:savanna\n    - terralith:ashen_savanna = minecraft:savanna\n    - terralith:basalt_cliffs = minecraft:basalt_deltas\n    - terralith:birch_taiga = minecraft:birch_forest\n    - terralith:blooming_plateau = minecraft:meadow\n    - terralith:blooming_valley = minecraft:flower_forest\n    - terralith:brushland = minecraft:plains\n    - terralith:bryce_canyon = minecraft:eroded_badlands\n    - terralith:caldera = minecraft:badlands\n    - terralith:cloud_forest = minecraft:flower_forest\n    - terralith:cold_shrubland = minecraft:snowy_plains\n    - terralith:desert_canyon = minecraft:desert\n    - terralith:desert_oasis = minecraft:desert\n    - terralith:desert_spires = minecraft:desert\n    - terralith:emerald_peaks = minecraft:stony_peaks\n    - terralith:forested_highlands = minecraft:taiga\n    - terralith:fractured_savanna = minecraft:windswept_savanna\n    - terralith:frozen_cliffs = minecraft:ice_spikes\n    - terralith:glacial_chasm = minecraft:ice_spikes\n    - terralith:granite_cliffs = minecraft:stony_shore\n    - terralith:gravel_beach = minecraft:stony_shore\n    - terralith:gravel_desert = minecraft:desert\n    - terralith:haze_mountain = minecraft:windswept_forest\n    - terralith:highlands = minecraft:plains\n    - terralith:hot_shrubland = minecraft:wooded_badlands\n    - terralith:ice_marsh = minecraft:swamp\n    - terralith:jungle_mountains = minecraft:jungle\n    - terralith:lavender_forest = minecraft:cherry_grove\n    - terralith:lavender_valley = minecraft:cherry_grove\n    - terralith:lush_desert = minecraft:desert\n    - terralith:lush_valley = minecraft:taiga\n    - terralith:mirage_isles = nothing\n    - terralith:moonlight_grove = minecraft:forest\n    - terralith:moonlight_valley = minecraft:forest\n    - terralith:orchid_swamp = minecraft:mangrove_swamp\n    - terralith:painted_mountains = minecraft:eroded_badlands\n    - terralith:red_oasis = minecraft:wooded_badlands\n    - terralith:rocky_jungle = minecraft:jungle\n    - terralith:rocky_mountains = minecraft:frozen_peaks\n    - terralith:rocky_shrubland = minecraft:snowy_plains\n    - terralith:sakura_grove = minecraft:cherry_grove\n    - terralith:sakura_valley = minecraft:cherry_grove\n    - terralith:sandstone_valley = minecraft:desert\n    - terralith:savanna_badlands = minecraft:windswept_savanna\n    - terralith:savanna_slopes = minecraft:windswept_savanna\n    - terralith:scarlet_mountains = minecraft:snowy_taiga\n    - terralith:shield_clearing = minecraft:windswept_gravelly_hills\n    - terralith:shield = minecraft:old_growth_spruce_taiga\n    - terralith:shrubland = minecraft:windswept_savanna\n    - terralith:siberian_grove = minecraft:grove\n    - terralith:siberian_taiga = minecraft:snowy_taiga\n    - terralith:skylands = minecraft:forest\n    - terralith:skylands_autumn = minecraft:forest\n    - terralith:skylands_spring = minecraft:forest\n    - terralith:skylands_summer = minecraft:forest\n    - terralith:skylands_winter = minecraft:forest\n    - terralith:snowy_badlands = minecraft:snowy_slopes\n    - terralith:snowy_cherry_grove = minecraft:cherry_grove\n    - terralith:snowy_maple_forest = minecraft:birch_forest\n    - terralith:snowy_shield = minecraft:snowy_taiga\n    - terralith:steppe = minecraft:plains\n    - terralith:stony_spires = minecraft:jagged_peaks\n    - terralith:temperate_highlands = minecraft:plains\n    - terralith:tropical_jungle = minecraft:jungle\n    - terralith:valley_clearing = minecraft:plains\n    - terralith:volcanic_crater = minecraft:badlands\n    - terralith:volcanic_peaks = minecraft:badlands\n    - terralith:warm_river = minecraft:river\n    - terralith:warped_mesa = minecraft:eroded_badlands\n    - terralith:white_cliffs = minecraft:badlands\n    - terralith:white_mesa = minecraft:eroded_badlands\n    - terralith:windswept_spires = minecraft:jagged_peaks\n    - terralith:wintry_forest = minecraft:grove\n    - terralith:wintry_lowlands = minecraft:grove\n    - terralith:yellowstone = minecraft:badlands\n    - terralith:yosemite_cliffs = minecraft:forest\n    - terralith:yosemite_lowlands = minecraft:old_growth_pine_taiga\n    - terralith:cave/andesite_caves = minecraft:dripstone_caves\n    - terralith:cave/desert_caves = minecraft:dripstone_caves\n    - terralith:cave/diorite_caves = minecraft:dripstone_caves\n    - terralith:cave/fungal_caves = minecraft:dripstone_caves\n    - terralith:cave/granite_caves = minecraft:dripstone_caves\n    - terralith:cave/ice_caves = minecraft:dripstone_caves\n    - terralith:cave/infested_caves = minecraft:dripstone_caves\n    - terralith:cave/thermal_caves = minecraft:dripstone_caves\n    - terralith:cave/underground_jungle = minecraft:dripstone_caves\n    - terralith:cave/crystal_caves = minecraft:dripstone_caves\n    - terralith:cave/deep_caves = minecraft:dripstone_caves\n    - terralith:cave/frostfire_caves = minecraft:dripstone_caves\n    - terralith:cave/mantle_caves = minecraft:dripstone_caves\n    - terralith:cave/tuff_caves = minecraft:dripstone_caves\n";
        Pattern pattern = Pattern.compile("-\\s*([^:]+):(.*?)\\s*=\\s*(Minecraft):(.*?)$", 2);
        for (String line : lines = mappings.split("\\r?\\n")) {
            String[] parts;
            if ((line = line.trim()).isEmpty() || line.startsWith("//")) continue;
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                String pluginName = matcher.group(1).trim().toLowerCase();
                String customBiomeKey = matcher.group(2).trim().toLowerCase();
                String defaultBiomeKey = matcher.group(4).trim().toLowerCase();
                if (defaultBiomeKey.equalsIgnoreCase("nothing")) continue;
                String defaultBiomeId = "minecraft:" + defaultBiomeKey;
                String customBiomeId = pluginName + ":" + customBiomeKey;
                defaultBiomeToCustomBiomes.computeIfAbsent(defaultBiomeId, k -> new ArrayList()).add(customBiomeId);
                continue;
            }
            if (line.contains("nothing") || !line.contains("=") || (parts = line.split("=")).length != 2) continue;
            String customBiomePart = parts[0].replaceFirst("-\\s*", "").trim();
            String defaultBiomePart = parts[1].trim();
            if (defaultBiomePart.equalsIgnoreCase("NOTHING")) continue;
            String customBiomeId = customBiomePart.toLowerCase();
            Object defaultBiomeId = defaultBiomePart.replace("minecraft:", "").trim();
            defaultBiomeId = !((String)defaultBiomeId).contains(":") ? "minecraft:" + ((String)defaultBiomeId).toLowerCase() : ((String)defaultBiomeId).toLowerCase();
            defaultBiomeToCustomBiomes.computeIfAbsent((String)defaultBiomeId, k -> new ArrayList()).add(customBiomeId);
        }
    }

    public static List<String> getCustomBiomes(String defaultBiomeId) {
        if (defaultBiomeId == null || defaultBiomeId.isEmpty()) {
            return Collections.emptyList();
        }
        return defaultBiomeToCustomBiomes.getOrDefault(defaultBiomeId.toLowerCase(), Collections.emptyList());
    }

    public static List<String> getCustomBiomes(Biome defaultBiome) {
        if (defaultBiome == null) {
            return Collections.emptyList();
        }
        NamespacedKey key = defaultBiome.getKey();
        String defaultBiomeId = key.getNamespace() + ":" + key.getKey();
        return CustomBiomeCompatibility.getCustomBiomes(defaultBiomeId);
    }
}

