/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.magmacore.dlc;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.magmaguy.magmacore.MagmaCore;
import com.magmaguy.magmacore.events.ModelInstallationEvent;
import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.magmacore.util.ZipFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class ConfigurationImporter {
    private final Path eliteMobsPath = Path.of(MagmaCore.getInstance().getRequestingPlugin().getDataFolder().getParentFile().getAbsolutePath(), new String[0]).resolve("EliteMobs");
    private final Path extractioncraftPath = Path.of(MagmaCore.getInstance().getRequestingPlugin().getDataFolder().getParentFile().getAbsolutePath(), new String[0]).resolve("Extractioncraft");
    private final Path betterStructuresPath = Path.of(MagmaCore.getInstance().getRequestingPlugin().getDataFolder().getParentFile().getAbsolutePath(), new String[0]).resolve("BetterStructures");
    private final Path freeMinecraftModelsPath = Path.of(MagmaCore.getInstance().getRequestingPlugin().getDataFolder().getParentFile().getAbsolutePath(), new String[0]).resolve("FreeMinecraftModels");
    private final Path modelEnginePath = Path.of(MagmaCore.getInstance().getRequestingPlugin().getDataFolder().getParentFile().getAbsolutePath(), new String[0]).resolve("ModelEngine");
    private final Path eternalTDPath = Path.of(MagmaCore.getInstance().getRequestingPlugin().getDataFolder().getParentFile().getAbsolutePath(), new String[0]).resolve("EternalTD");
    private PluginPlatform pluginPlatform;
    private File importsFolder;
    private boolean modelsInstalled = false;

    public ConfigurationImporter() {
        if (!this.createImportsDirectory()) {
            return;
        }
        this.importsFolder = this.getImportsDirectory();
        if (this.importsFolder == null || this.importsFolder.listFiles().length == 0) {
            return;
        }
        this.pluginPlatform = this.getPluginPlatform(MagmaCore.getInstance().getRequestingPlugin().getName());
        this.processImportsFolder();
        if (Bukkit.getPluginManager().isPluginEnabled("FreeMinecraftModels") && this.modelsInstalled) {
            Bukkit.getPluginManager().callEvent((Event)new ModelInstallationEvent());
        }
    }

    private static void deleteDirectory(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            for (File iteratedFile : file.listFiles()) {
                if (iteratedFile == null) continue;
                ConfigurationImporter.deleteDirectory(iteratedFile);
            }
        }
        Logger.info("Cleaning up " + file.getPath());
        file.delete();
    }

    private static void moveWorlds(File worldcontainerFile) {
        for (File file : worldcontainerFile.listFiles()) {
            try {
                File worldContainer = Bukkit.getWorldContainer().getCanonicalFile();
                Path worldContainerPath = worldContainer.toPath().normalize().toAbsolutePath();
                Path destinationPath = worldContainerPath.resolve(file.getName());
                File destinationFile = destinationPath.toFile();
                if (destinationFile.exists()) {
                    Logger.info("Overriding existing directory " + destinationFile.getPath());
                    if (Bukkit.getWorld((String)file.getName()) != null) {
                        Bukkit.unloadWorld((String)file.getName(), (boolean)false);
                        Logger.warn("Unloaded world " + file.getName() + " for safe replacement!");
                    }
                    ConfigurationImporter.deleteDirectory(destinationFile);
                }
                ConfigurationImporter.moveDirectory(file, destinationPath);
            }
            catch (Exception exception) {
                Logger.warn("Failed to move worlds for " + file.getName() + "! Tell the dev!");
                exception.printStackTrace();
            }
        }
    }

    private static void moveDirectory(File unzippedDirectory, Path targetPath) {
        for (File file : unzippedDirectory.listFiles()) {
            try {
                ConfigurationImporter.moveFile(file, targetPath);
            }
            catch (Exception exception) {
                Logger.warn("Failed to move directories for " + file.getName() + "! Tell the dev!");
                exception.printStackTrace();
            }
        }
    }

    private static void moveFile(File file, Path targetPath) {
        try {
            Path destinationPath = targetPath.resolve(file.getName());
            if (file.isDirectory()) {
                if (Files.exists(destinationPath, new LinkOption[0])) {
                    for (File iteratedFile : file.listFiles()) {
                        ConfigurationImporter.moveFile(iteratedFile, destinationPath);
                    }
                } else {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                    Files.move(file.toPath().normalize().toAbsolutePath(), destinationPath, StandardCopyOption.REPLACE_EXISTING);
                }
            } else {
                Files.createDirectories(targetPath, new FileAttribute[0]);
                Files.move(file.toPath().normalize().toAbsolutePath(), destinationPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception exception) {
            Logger.warn("Failed to move file/directories for " + file.getName() + "! Tell the dev!");
            exception.printStackTrace();
        }
    }

    private boolean createImportsDirectory() {
        Path configurationsPath = Paths.get(MagmaCore.getInstance().getRequestingPlugin().getDataFolder().getAbsolutePath(), new String[0]);
        Path importsPath = configurationsPath.normalize().resolve("imports");
        if (!Files.isDirectory(importsPath, new LinkOption[0])) {
            try {
                File importsFile = importsPath.toFile();
                if (!importsFile.getParentFile().exists()) {
                    importsPath.toFile().mkdirs();
                }
                Files.createDirectories(importsPath, new FileAttribute[0]);
                return true;
            }
            catch (Exception exception) {
                Logger.warn("Failed to create import directory! Tell the dev!");
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private File getImportsDirectory() {
        try {
            File dir = Paths.get(MagmaCore.getInstance().getRequestingPlugin().getDataFolder().getCanonicalPath(), new String[0]).resolve("imports").toFile();
            return dir;
        }
        catch (Exception ex) {
            Logger.warn("Failed to get imports folder! Report this to the dev!");
            ex.printStackTrace();
            return null;
        }
    }

    private PluginPlatform getPluginPlatform(String name) {
        if (name == null) {
            return PluginPlatform.NONE;
        }
        switch (name.toLowerCase(Locale.ROOT)) {
            case "elitemobs": {
                return PluginPlatform.ELITEMOBS;
            }
            case "extractioncraft": {
                return PluginPlatform.EXTRACTIONCRAFT;
            }
            case "betterstructures": {
                return PluginPlatform.BETTERSTRUCTURES;
            }
            case "freeminecraftmodels": {
                return PluginPlatform.FREEMINECRAFTMODELS;
            }
            case "eternaltd": {
                return PluginPlatform.ETERNALTD;
            }
        }
        return PluginPlatform.NONE;
    }

    private void processImportsFolder() {
        for (File zippedFile : this.importsFolder.listFiles()) {
            if (zippedFile.getName().endsWith(".zip")) {
                this.unzipImportFile(zippedFile);
                continue;
            }
            if (this.pluginPlatform == PluginPlatform.FREEMINECRAFTMODELS && zippedFile.getName().endsWith(".bbmodel")) {
                this.processBbmodel(zippedFile);
                continue;
            }
            if (zippedFile.isDirectory()) {
                boolean incorrectlyUnzippedFolder = false;
                for (File iteratedFile : zippedFile.listFiles()) {
                    if (!iteratedFile.getName().equalsIgnoreCase("pack.meta")) continue;
                    incorrectlyUnzippedFolder = true;
                    break;
                }
                if (!incorrectlyUnzippedFolder) continue;
                this.processUnzippedFile(zippedFile);
                continue;
            }
            Logger.warn("File " + zippedFile.getPath() + " can't be imported! It will be skipped.");
        }
    }

    private void unzipImportFile(File zippedFile) {
        try {
            File unzippedFolder = ZipFile.unzip(zippedFile, new File(zippedFile.getAbsolutePath().replace(".zip", "")));
            this.processUnzippedFile(unzippedFolder);
            ConfigurationImporter.deleteDirectory(zippedFile);
        }
        catch (Exception ex) {
            Logger.warn("Failed to unzip " + zippedFile.getPath() + " ! This probably means the file is corrupted.");
            Logger.warn("To fix this, delete this file from the imports folder and download a clean copy!");
            ex.printStackTrace();
        }
    }

    private void processUnzippedFile(File unzippedFolder) {
        PluginPlatform platform = this.pluginPlatform;
        for (File unzippedFile : unzippedFolder.listFiles()) {
            if (!unzippedFile.getName().equalsIgnoreCase("pack.meta")) continue;
            platform = this.getPluginPlatform(this.readPackMeta(unzippedFile));
        }
        for (File unzippedFile : unzippedFolder.listFiles()) {
            this.moveUnzippedFiles(unzippedFile, platform);
        }
        ConfigurationImporter.deleteDirectory(unzippedFolder);
    }

    private void moveUnzippedFiles(File unzippedFile, PluginPlatform platform) {
        Path targetPath = this.getTargetPath(unzippedFile.getName(), platform);
        if (targetPath == null) {
            return;
        }
        if (targetPath.toFile().getParentFile() != null && !targetPath.toFile().getParentFile().exists()) {
            targetPath.toFile().getParentFile().mkdirs();
        }
        if (targetPath.toFile().exists()) {
            targetPath.toFile().mkdir();
        }
        if (unzippedFile.isDirectory()) {
            if (unzippedFile.getName().equalsIgnoreCase("worldcontainer")) {
                ConfigurationImporter.moveWorlds(unzippedFile);
            } else {
                ConfigurationImporter.moveDirectory(unzippedFile, targetPath);
            }
        } else {
            ConfigurationImporter.moveFile(unzippedFile, targetPath);
        }
    }

    private Path getTargetPath(String folder, PluginPlatform platform) {
        if (platform == PluginPlatform.FREEMINECRAFTMODELS) {
            return this.freeMinecraftModelsPath.resolve("models");
        }
        switch (folder) {
            case "custombosses": {
                if (platform != PluginPlatform.ELITEMOBS && platform != PluginPlatform.BETTERSTRUCTURES && platform != PluginPlatform.EXTRACTIONCRAFT) break;
                return this.eliteMobsPath.resolve("custombosses");
            }
            case "customitems": {
                if (platform != PluginPlatform.ELITEMOBS && platform != PluginPlatform.BETTERSTRUCTURES && platform != PluginPlatform.EXTRACTIONCRAFT) break;
                return this.eliteMobsPath.resolve("customitems");
            }
            case "customtreasurechests": {
                if (platform != PluginPlatform.ELITEMOBS && platform != PluginPlatform.BETTERSTRUCTURES && platform != PluginPlatform.EXTRACTIONCRAFT) break;
                return this.eliteMobsPath.resolve("customtreasurechests");
            }
            case "dungeonpackages": 
            case "content_packages": {
                if (platform == PluginPlatform.ELITEMOBS) {
                    return this.eliteMobsPath.resolve("content_packages");
                }
                if (platform == PluginPlatform.BETTERSTRUCTURES) {
                    return this.betterStructuresPath.resolve("content_packages");
                }
                if (platform != PluginPlatform.EXTRACTIONCRAFT) break;
                return this.extractioncraftPath.resolve("content_packages");
            }
            case "customevents": {
                if (platform != PluginPlatform.ELITEMOBS) break;
                return this.eliteMobsPath.resolve("customevents");
            }
            case "customspawns": {
                if (platform != PluginPlatform.ELITEMOBS) break;
                return this.eliteMobsPath.resolve("customspawns");
            }
            case "customquests": {
                if (platform != PluginPlatform.ELITEMOBS && platform != PluginPlatform.EXTRACTIONCRAFT) break;
                return this.eliteMobsPath.resolve("customquests");
            }
            case "customarenas": {
                if (platform != PluginPlatform.ELITEMOBS) break;
                return this.eliteMobsPath.resolve("customarenas");
            }
            case "npcs": {
                if (platform == PluginPlatform.ELITEMOBS || platform == PluginPlatform.EXTRACTIONCRAFT) {
                    return this.eliteMobsPath.resolve("npcs");
                }
                if (platform != PluginPlatform.ETERNALTD) break;
                return this.eternalTDPath.resolve("npcs");
            }
            case "wormholes": {
                if (platform != PluginPlatform.ELITEMOBS) break;
                return this.eliteMobsPath.resolve("wormholes");
            }
            case "powers": {
                if (platform != PluginPlatform.ELITEMOBS && platform != PluginPlatform.BETTERSTRUCTURES && platform != PluginPlatform.EXTRACTIONCRAFT) break;
                return this.eliteMobsPath.resolve("powers");
            }
            case "worldcontainer": {
                try {
                    File wc = Bukkit.getWorldContainer().getCanonicalFile();
                    return wc.toPath().normalize().toAbsolutePath();
                }
                catch (IOException e) {
                    Logger.warn("Failed to resolve world container path canonically!");
                    e.printStackTrace();
                    return null;
                }
            }
            case "world_blueprints": {
                if (platform != PluginPlatform.ELITEMOBS) break;
                return this.eliteMobsPath.resolve("world_blueprints");
            }
            case "ModelEngine": 
            case "models": {
                this.modelsInstalled = true;
                if (Bukkit.getPluginManager().isPluginEnabled("FreeMinecraftModels")) {
                    return this.freeMinecraftModelsPath.resolve("models");
                }
                if (Bukkit.getPluginManager().isPluginEnabled("ModelEngine")) {
                    return this.modelEnginePath.resolve("blueprints");
                }
                return this.freeMinecraftModelsPath.resolve("models");
            }
            case "schematics": {
                if (platform == PluginPlatform.ELITEMOBS) {
                    Logger.warn("You just tried to import legacy content! Schematic dungeons no longer exist as of EliteMobs 9.0, use BetterStructures shrines instead!");
                    break;
                }
                if (platform != PluginPlatform.BETTERSTRUCTURES) break;
                return this.betterStructuresPath.resolve("schematics");
            }
            case "levels": {
                if (platform != PluginPlatform.ETERNALTD) break;
                return this.eternalTDPath.resolve("levels");
            }
            case "waves": {
                if (platform != PluginPlatform.ETERNALTD) break;
                return this.eternalTDPath.resolve("waves");
            }
            case "worlds": {
                if (platform != PluginPlatform.ETERNALTD) break;
                return this.eternalTDPath.resolve("worlds");
            }
            case "elitemobs": {
                if (platform != PluginPlatform.BETTERSTRUCTURES) break;
                return this.eliteMobsPath;
            }
            case "pack.meta": {
                return null;
            }
            case "spawn_pools": {
                if (platform == PluginPlatform.BETTERSTRUCTURES || platform == PluginPlatform.EXTRACTIONCRAFT) {
                    return this.betterStructuresPath.resolve("spawn_pools");
                }
            }
            case "components": {
                if (platform == PluginPlatform.BETTERSTRUCTURES || platform == PluginPlatform.EXTRACTIONCRAFT) {
                    return this.betterStructuresPath.resolve("components");
                }
            }
            case "modules": {
                if (platform == PluginPlatform.BETTERSTRUCTURES || platform == PluginPlatform.EXTRACTIONCRAFT) {
                    return this.betterStructuresPath.resolve("modules");
                }
            }
            case "module_generators": {
                if (platform == PluginPlatform.BETTERSTRUCTURES || platform == PluginPlatform.EXTRACTIONCRAFT) {
                    return this.betterStructuresPath.resolve("module_generators");
                }
            }
            case "loot_pools": {
                if (platform == PluginPlatform.EXTRACTIONCRAFT) {
                    return this.extractioncraftPath.resolve("loot_pools");
                }
            }
            case "loot_tables": {
                if (platform == PluginPlatform.EXTRACTIONCRAFT) {
                    return this.extractioncraftPath.resolve("loot_tables");
                }
            }
            default: {
                Logger.warn("Directory " + folder + " for zipped file was not recognized! Was the zipped file packaged correctly?");
                return null;
            }
        }
        Logger.warn("Directory " + folder + " for zipped file was not recognized! Was the zipped file packaged correctly?");
        return null;
    }

    private String readPackMeta(File packMetaFile) {
        if (packMetaFile == null || !packMetaFile.exists()) {
            Logger.warn("File " + (packMetaFile != null ? packMetaFile.getPath() : "null") + " does not exist or is not valid.");
            return null;
        }
        try {
            Path filePath = packMetaFile.getCanonicalFile().toPath().normalize().toAbsolutePath();
            return Files.readString(filePath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Logger.warn("Failed to read pack.meta file " + packMetaFile.getPath() + ". Ensure the file is readable.");
            e.printStackTrace();
            return null;
        }
    }

    private void processBbmodel(File bbmodelFile) {
        Object pathName;
        File parentFile;
        BufferedReader reader;
        Gson readerGson = new Gson();
        try {
            reader = Files.newBufferedReader(bbmodelFile.getCanonicalFile().toPath());
        }
        catch (Exception ex) {
            Logger.warn("Failed to read file " + bbmodelFile.getAbsolutePath());
            return;
        }
        Map jsonMap = (Map)readerGson.fromJson((Reader)reader, Map.class);
        Gson writerGson = new Gson();
        HashMap minifiedMap = new HashMap();
        minifiedMap.put("resolution", jsonMap.get("resolution"));
        minifiedMap.put("elements", jsonMap.get("elements"));
        minifiedMap.put("outliner", jsonMap.get("outliner"));
        ArrayList minifiedTextures = new ArrayList();
        ((ArrayList)jsonMap.get("textures")).forEach(innerMap -> minifiedTextures.add(Map.of("source", ((LinkedTreeMap)innerMap).get((Object)"source"), "id", ((LinkedTreeMap)innerMap).get((Object)"id"), "name", ((LinkedTreeMap)innerMap).get((Object)"name"))));
        minifiedMap.put("textures", minifiedTextures);
        minifiedMap.put("animations", jsonMap.get("animations"));
        ArrayList<String> parentFiles = new ArrayList<String>();
        File currentFile = bbmodelFile;
        while (!(parentFile = currentFile.getParentFile()).getName().equals("imports")) {
            parentFiles.add(parentFile.getName());
            currentFile = parentFile;
        }
        String modelsDirectory = this.freeMinecraftModelsPath.toFile().getAbsolutePath() + File.separatorChar + "models";
        if (parentFiles.isEmpty()) {
            pathName = modelsDirectory + File.separatorChar + bbmodelFile.getName().replace(".bbmodel", ".fmmodel");
        } else {
            StringBuilder sb = new StringBuilder(modelsDirectory);
            for (int i = parentFiles.size() - 1; i >= 0; --i) {
                sb.append(File.separatorChar).append((String)parentFiles.get(i));
            }
            sb.append(File.separatorChar).append(bbmodelFile.getName().replace(".bbmodel", ".fmmodel"));
            pathName = sb.toString();
        }
        try {
            FileUtils.writeStringToFile((File)new File((String)pathName), (String)writerGson.toJson(minifiedMap), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Logger.warn("Failed to generate the minified file!");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static enum PluginPlatform {
        ELITEMOBS,
        EXTRACTIONCRAFT,
        BETTERSTRUCTURES,
        FREEMINECRAFTMODELS,
        ETERNALTD,
        RESURRECTIONCHEST,
        NONE;

    }
}

