/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import owmii.powah.Powah;
import owmii.powah.item.ReactorItem;
import owmii.powah.lib.client.util.RenderTypes;

public class ReactorOverlayHandler {
    static final ResourceLocation OV_TEXTURE = Powah.id("textures/misc/reactor_ov.png");

    public static void onRenderLast(PoseStack poseStack, Camera camera) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.level == null) {
            return;
        }
        boolean flag = false;
        boolean flag1 = false;
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!(stack.getItem() instanceof ReactorItem)) continue;
            flag = true;
            if (player.getInventory().countItem(stack.getItem()) < 36) break;
            flag1 = true;
            break;
        }
        if (!flag) {
            return;
        }
        HitResult result = mc.hitResult;
        if (result instanceof BlockHitResult) {
            boolean isReplaceable;
            BlockHitResult br = (BlockHitResult)result;
            boolean bl = isReplaceable = mc.level.getBlockState(br.getBlockPos()).canBeReplaced() && !mc.level.isEmptyBlock(br.getBlockPos());
            if (mc.level.isEmptyBlock(br.getBlockPos()) || !isReplaceable && !br.getDirection().equals((Object)Direction.UP)) {
                return;
            }
            BlockPos pos = isReplaceable ? br.getBlockPos() : br.getBlockPos().relative(br.getDirection());
            List<BlockPos> list = BlockPos.betweenClosedStream((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 3, 1)).map(BlockPos::immutable).toList();
            int color = 7725206;
            if (!flag1 && !player.isCreative()) {
                color = 13566990;
            }
            if (color != 13566990) {
                List entities;
                for (BlockPos blockPos : list) {
                    if (mc.level.getBlockState(blockPos).canBeReplaced()) continue;
                    color = 13566990;
                    break;
                }
                if (!(entities = mc.level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(1.0, 3.0, 1.0))).isEmpty()) {
                    color = 13566990;
                }
            }
            poseStack.pushPose();
            Vec3 projectedView = camera.getPosition();
            Quaternionf rotation = new Quaternionf((Quaternionfc)camera.rotation());
            rotation.invert();
            poseStack.mulPose(rotation);
            poseStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
            poseStack.translate(-1.0, 0.001, -1.0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            MultiBufferSource.BufferSource buffers = mc.renderBuffers().bufferSource();
            RenderType renderType = RenderTypes.createReactorOverlay(OV_TEXTURE);
            VertexConsumer buffer = buffers.getBuffer(renderType);
            buffer.addVertex(poseStack.last().pose(), (float)pos.getX(), (float)pos.getY(), (float)(pos.getZ() + 3)).setColor(r, g, b, 1.0f).setUv(0.0f, 1.0f).setLight(0xF000F0);
            buffer.addVertex(poseStack.last().pose(), (float)(pos.getX() + 3), (float)pos.getY(), (float)(pos.getZ() + 3)).setColor(r, g, b, 1.0f).setUv(1.0f, 1.0f).setLight(0xF000F0);
            buffer.addVertex(poseStack.last().pose(), (float)(pos.getX() + 3), (float)pos.getY(), (float)pos.getZ()).setColor(r, g, b, 1.0f).setUv(1.0f, 0.0f).setLight(0xF000F0);
            buffer.addVertex(poseStack.last().pose(), (float)pos.getX(), (float)pos.getY(), (float)pos.getZ()).setColor(r, g, b, 1.0f).setUv(0.0f, 0.0f).setLight(0xF000F0);
            poseStack.popPose();
            buffers.endBatch(renderType);
        }
    }
}

