/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.client.model.OrbModel;
import owmii.powah.client.model.PowahLayerDefinitions;
import owmii.powah.lib.client.renderer.tile.AbstractTileRenderer;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.util.math.V3d;

public class EnergizingOrbRenderer
extends AbstractTileRenderer<EnergizingOrbTile> {
    private final OrbModel model;

    protected EnergizingOrbRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.model = new OrbModel(context.bakeLayer(PowahLayerDefinitions.ORB));
    }

    @Override
    public void render(EnergizingOrbTile te, float pt, PoseStack matrix, MultiBufferSource rtb, Minecraft mc, ClientLevel world, LocalPlayer player, int light, int ov) {
        Inventory inv = te.getInventory();
        if (!inv.isEmpty()) {
            float ticks = ((float)te.ticks + pt) / 200.0f;
            ItemStack output = inv.getStackInSlot(0);
            if (!output.isEmpty()) {
                matrix.pushPose();
                matrix.translate(0.5, 0.6, 0.5);
                matrix.mulPose(Axis.YP.rotationDegrees(-ticks * 360.0f));
                matrix.scale(0.35f, 0.35f, 0.35f);
                mc.getItemRenderer().renderStatic(output, ItemDisplayContext.FIXED, light, ov, matrix, rtb, (Level)world, 0);
                matrix.popPose();
            } else {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(inv.getNonEmptyStacks());
                List<V3d> circled = V3d.from(Vec3.ZERO).circled(stacks.size(), 0.1);
                for (int i = 0; i < circled.size(); ++i) {
                    V3d v3d1 = circled.get(i);
                    ItemStack stack = (ItemStack)stacks.get(i);
                    if (stack.isEmpty()) continue;
                    matrix.pushPose();
                    if (stacks.size() == 1) {
                        matrix.translate(0.5, 0.6, 0.5);
                    } else {
                        matrix.translate(v3d1.x + 0.5, v3d1.y + 0.6, v3d1.z + 0.5);
                    }
                    matrix.scale(0.35f, 0.35f, 0.35f);
                    matrix.mulPose(Axis.YP.rotationDegrees(-ticks * 360.0f));
                    mc.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, light, ov, matrix, rtb, (Level)world, 0);
                    matrix.popPose();
                }
            }
        }
        matrix.pushPose();
        matrix.translate(0.5, 0.5, 0.5);
        matrix.mulPose(te.getOrbUp().getRotation());
        matrix.translate(0.0, 0.1, 0.0);
        matrix.scale(1.8f, 1.8f, 1.8f);
        this.model.render(te, this, matrix, rtb, light, ov);
        matrix.popPose();
    }
}

