/*
 * Decompiled with CFR 0.152.
 */
package de.darksmp.itemframetoggle;

import de.darksmp.itemframetoggle.metrics.MetricsInitializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ItemFrameTogglePlugin
extends JavaPlugin
implements Listener {
    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        MetricsInitializer.init(this);
        this.getLogger().info("ItemFrameToggle aktiviert");
    }

    public void onDisable() {
        this.getLogger().info("ItemFrameToggle deaktiviert");
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Entity clicked = event.getRightClicked();
        if (!(clicked instanceof ItemFrame)) {
            return;
        }
        ItemFrame frame = (ItemFrame)clicked;
        if (!player.isSneaking()) {
            return;
        }
        if (!player.hasPermission("itemframe.toggle")) {
            return;
        }
        event.setCancelled(true);
        boolean visible = frame.isVisible();
        frame.setVisible(!visible);
        player.sendActionBar("\u00a77ItemFrame ist jetzt " + (visible ? "\u00a7cunsichtbar" : "\u00a7a\u00adsichtbar"));
    }
}

