/*
 * Decompiled with CFR 0.152.
 */
package de.darksmp.itemframetoggle.metrics;

import de.darksmp.itemframetoggle.metrics.bstats.bukkit.Metrics;
import de.darksmp.itemframetoggle.metrics.bstats.charts.SimplePie;
import de.darksmp.itemframetoggle.metrics.bstats.charts.SingleLineChart;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public final class MetricsInitializer {
    private static final int BSTATS_PLUGIN_ID = 28040;

    private MetricsInitializer() {
    }

    public static void init(JavaPlugin plugin) {
        try {
            Metrics metrics = new Metrics(plugin, 28040);
            metrics.addCustomChart(new SingleLineChart("online_players", () -> Bukkit.getOnlinePlayers().size()));
            metrics.addCustomChart(new SimplePie("server_type", () -> {
                String v = Bukkit.getVersion().toLowerCase();
                if (v.contains("purpur")) {
                    return "Purpur";
                }
                if (v.contains("paper")) {
                    return "Paper";
                }
                if (v.contains("spigot")) {
                    return "Spigot";
                }
                return "Unknown";
            }));
            plugin.getLogger().info("[bStats] Metrics aktiv (Plugin-ID: 28040)");
        }
        catch (Exception ex) {
            plugin.getLogger().warning("[bStats] Fehler beim Initialisieren von bStats: " + ex.getMessage());
        }
    }
}

