/*
 * Decompiled with CFR 0.152.
 */
package xyz.sillyjune.notebook;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_474;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7529;
import xyz.sillyjune.notebook.Notebook;
import xyz.sillyjune.notebook.NotebookData;

@Environment(value=EnvType.CLIENT)
public class NotebookScreen
extends class_437 {
    private class_7529 editBox;
    public int bookOffset = 0;
    private static NotebookData DATA;
    public static class_4185 buttonDelBook;
    public static class_4185 closeButton;
    public static class_4185 buttonRenameBook;
    public static class_4185 buttonNewBook;
    public static class_4185 buttonIncreaseOffset;
    public static class_4185 buttonDecreaseOffset;
    public class_4185[] switchableBooks = new class_4185[]{null, null, null, null, null};
    private int pageIndex;
    private int cursorIndex;
    private List<class_5481> cachedPage = Collections.emptyList();
    private class_342 bookNameField;
    private class_4185 newPageButton;
    private class_4185 delPageButton;
    private class_474 nextPageButton;
    private class_474 previousPageButton;
    private final boolean pageTurnSound;

    public NotebookScreen() {
        this(false);
    }

    private NotebookScreen(boolean playPageTurnSound) {
        super(class_333.field_18967);
        this.pageTurnSound = playPageTurnSound;
    }

    protected void newPage() {
        String[] new_pages = new String[NotebookScreen.DATA.content.length + 1];
        int i = 0;
        String[] stringArray = NotebookScreen.DATA.content;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String page;
            new_pages[i] = page = stringArray[j];
            ++i;
        }
        new_pages[new_pages.length - 1] = " ";
        NotebookScreen.DATA.content = new_pages;
        DATA.write();
        this.goToNextPage();
    }

    protected void delPage() {
        String[] new_pages = new String[NotebookScreen.DATA.content.length - 1];
        for (int i = 0; i < new_pages.length; ++i) {
            new_pages[i] = NotebookScreen.DATA.content[i];
            ++i;
        }
        NotebookScreen.DATA.content = new_pages;
        DATA.write();
        this.goToPreviousPage();
    }

    protected String readPage(int pagei) {
        if (pagei >= NotebookScreen.DATA.content.length) {
            this.newPage();
        }
        return Objects.requireNonNullElse(NotebookScreen.DATA.content[pagei], "");
    }

    void goto_book(String book) {
        int bIdx = 0;
        for (String iter : Objects.requireNonNull(new File(Notebook.BOOK_FOLDER).list())) {
            if (Objects.equals(iter, book)) break;
            ++bIdx;
        }
        DATA = NotebookData.read(Objects.requireNonNull(new File(Notebook.BOOK_FOLDER).list())[bIdx]);
        this.bookNameField.method_1852(NotebookScreen.DATA.location.replace(".json", ""));
        this.pageIndex = 0;
        this.updatePageButtons();
    }

    protected void goToPreviousPage() {
        if (this.pageIndex > 0) {
            --this.pageIndex;
        }
        this.cursorIndex = this.readPage(this.pageIndex).length();
        this.updatePageButtons();
    }

    protected void goToNextPage() {
        if (this.pageIndex < NotebookScreen.DATA.content.length - 1) {
            ++this.pageIndex;
        }
        this.cursorIndex = this.readPage(this.pageIndex).length();
        this.updatePageButtons();
    }

    String getBookNameText() {
        return this.bookNameField.method_1882().replace(" ", "-");
    }

    void initBookSwitching() {
        int it;
        String[] books = Objects.requireNonNull(new File(Notebook.BOOK_FOLDER).list());
        int replaced = 0;
        for (it = 0; it != 5 && it + this.bookOffset <= books.length - 1; ++it) {
            replaced = it;
            String book = books[it + this.bookOffset];
            if (this.switchableBooks[it] != null) {
                this.switchableBooks[it].field_22764 = false;
            }
            this.switchableBooks[it] = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)book.replace(".json", "")), button -> this.goto_book(book)).method_46434(5, 55 + 25 * it, 108, 20).method_46431());
        }
        for (it = replaced + 1; it != 5; ++it) {
            if (this.switchableBooks[it] == null) continue;
            this.switchableBooks[it].field_22764 = false;
            this.switchableBooks[it] = null;
        }
    }

    protected void method_25426() {
        DATA = NotebookData.read("default.json");
        this.pageIndex = 0;
        this.editBox = class_7529.method_71507().method_71515(false).method_71514(-16777216).method_71516(-16777216).method_71513(false).method_71511(false).method_71508((this.field_22789 - 114) / 2 - 8).method_71512(28).method_71509(this.field_22793, 122, 134, class_5244.field_39003);
        this.editBox.method_44402(1024);
        closeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, 196, 200, 20).method_46431());
        int i = (this.field_22789 - 192) / 2;
        this.nextPageButton = (class_474)this.method_37063((class_364)new class_474(i + 116, 159, true, button -> this.goToNextPage(), this.pageTurnSound));
        this.previousPageButton = (class_474)this.method_37063((class_364)new class_474(i + 43, 159, false, button -> this.goToPreviousPage(), this.pageTurnSound));
        this.newPageButton = (class_4185)this.method_37063((class_364)new class_344(i + 119, 155, 20, 20, Notebook.NEW_PAGE_ICON, button -> this.newPage()));
        this.delPageButton = (class_4185)this.method_37063((class_364)new class_344(i + 99, 155, 20, 20, Notebook.DEL_PAGE_ICON, button -> this.delPage()));
        this.bookNameField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, 5, 5, 108, 20, (class_2561)class_2561.method_43471((String)"notebook.text.field")));
        this.bookNameField.method_1888(true);
        this.bookNameField.method_1852("default");
        Objects.requireNonNull(this.field_22793);
        this.editBox.method_71506(14);
        this.method_37063((class_364)this.editBox);
        buttonIncreaseOffset = (class_4185)this.method_37063((class_364)new class_344(113, 155, 20, 20, Notebook.LAST_BOOK_ICON, button -> {
            ++this.bookOffset;
            this.initBookSwitching();
        }));
        buttonDecreaseOffset = (class_4185)this.method_37063((class_364)new class_344(115, 130, 20, 20, Notebook.NEXT_BOOK_ICON, button -> {
            if (this.bookOffset > 0) {
                --this.bookOffset;
                this.initBookSwitching();
            }
        }));
        buttonDelBook = (class_4185)this.method_37063((class_364)new class_344(55, 30, 20, 20, Notebook.DEL_BOOK_ICON, button -> {
            String[] books = Objects.requireNonNull(new File(Notebook.BOOK_FOLDER).list());
            boolean found = false;
            for (String iter : books) {
                if (!iter.equals(this.getBookNameText() + ".json")) continue;
                found = true;
                break;
            }
            if (!this.bookNameField.method_1882().isEmpty() && found) {
                try {
                    Files.delete(Path.of(Notebook.BOOK_FOLDER + "/" + NotebookScreen.DATA.location, new String[0]));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.bookNameField.method_1882().equals("default")) {
                    NotebookScreen.DATA.content = new String[1];
                    DATA.write();
                }
            }
            this.initBookSwitching();
        }));
        buttonNewBook = (class_4185)this.method_37063((class_364)new class_344(5, 30, 20, 20, Notebook.NEW_BOOK_ICON, button -> {
            String[] books = Objects.requireNonNull(new File(Notebook.BOOK_FOLDER).list());
            boolean found = false;
            for (String iter : books) {
                if (!iter.equals(this.getBookNameText() + ".json")) continue;
                found = true;
                break;
            }
            if (!this.bookNameField.method_1882().isEmpty() && !found) {
                DATA = new NotebookData(new String[1], this.getBookNameText() + ".json");
                DATA.write();
            }
            this.initBookSwitching();
        }));
        buttonRenameBook = (class_4185)this.method_37063((class_364)new class_344(30, 30, 20, 20, Notebook.RENAME_BOOK_ICON, button -> {
            String[] books = Objects.requireNonNull(new File(Notebook.BOOK_FOLDER).list());
            boolean found = false;
            for (String iter : books) {
                if (!iter.equals(this.getBookNameText() + ".json")) continue;
                found = true;
                break;
            }
            if (!this.bookNameField.method_1882().isEmpty() && !found) {
                String[] bookData = NotebookScreen.DATA.content;
                try {
                    Files.delete(Path.of(Notebook.BOOK_FOLDER + "/" + NotebookScreen.DATA.location, new String[0]));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                DATA = new NotebookData(bookData, this.getBookNameText() + ".json");
                DATA.write();
            }
            this.initBookSwitching();
        }));
        this.initBookSwitching();
        this.updatePageButtons();
        this.cursorIndex = this.readPage(this.pageIndex).length();
    }

    private void updatePageButtons() {
        boolean onFinalPage = this.pageIndex == NotebookScreen.DATA.content.length - 1;
        this.nextPageButton.field_22764 = !onFinalPage;
        this.newPageButton.field_22764 = onFinalPage;
        this.delPageButton.field_22764 = onFinalPage;
        this.previousPageButton.field_22764 = this.pageIndex > 0;
        this.editBox.method_44400(NotebookScreen.DATA.content[this.pageIndex]);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        if (!NotebookScreen.DATA.content[this.pageIndex].equals(this.editBox.method_44405())) {
            NotebookScreen.DATA.content[this.pageIndex] = this.editBox.method_44405();
            DATA.write();
        }
        context.method_25290(class_10799.field_56883, Notebook.BOOK_TEXTURE, (this.field_22789 - 192) / 2, 2, 0.0f, 0.0f, 192, 192, 256, 256);
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"book.pageIndicator", (Object[])new Object[]{this.pageIndex + 1, Math.max(NotebookScreen.DATA.content.length, 1)}), (this.field_22789 - 192) / 2 - this.field_22793.method_27525((class_5348)class_2561.method_43469((String)"book.pageIndicator", (Object[])new Object[]{this.pageIndex + 1, Math.max(NotebookScreen.DATA.content.length, 1)})) + 192 - 44, 18, -16777216, false);
        if (Notebook.GAY) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"notebook.gay"), 5, this.field_22790 - 22, -1, true);
        }
        if (Notebook.CONFIG.debug()) {
            context.method_51439(this.field_22793, class_2561.method_30163((String)("Notebook v5.0.0 " + class_2561.method_43471((String)"devwarning.info").getString())), 5, this.field_22790 - 10, -1, true);
        } else {
            context.method_51439(this.field_22793, class_2561.method_30163((String)"Notebook v5.0.0"), 5, this.field_22790 - 10, -1, true);
        }
    }
}

