/*
 * Decompiled with CFR 0.152.
 */
package xyz.sillyjune.notebook;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import xyz.sillyjune.notebook.Notebook;

@Environment(value=EnvType.CLIENT)
public class NotebookData {
    String[] content;
    String location;

    NotebookData(String[] content, String location) {
        this.content = content;
        this.location = location;
    }

    public static NotebookData read(String location) {
        File jsondata = new File(Notebook.BOOK_FOLDER + "/" + location);
        StringBuilder d = new StringBuilder();
        try {
            Scanner reader = new Scanner(jsondata);
            while (reader.hasNextLine()) {
                String data = reader.nextLine();
                d.append(data);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            Notebook.LOGGER.error("Failed to read book!\n" + String.valueOf(e));
            NotebookData data = new NotebookData(new String[0], location);
            data.write();
        }
        String json = d.toString();
        return (NotebookData)new Gson().fromJson(json, NotebookData.class);
    }

    public void write() {
        String json = new Gson().toJson((Object)this);
        try {
            FileWriter writer = new FileWriter(Notebook.BOOK_FOLDER + "/" + this.location);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            Notebook.LOGGER.error("Failed to write book!\n" + String.valueOf(e));
        }
    }
}

