/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.at.network.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SendEntityNbtToClient {
    private CompoundTag tag;
    private int id;

    public SendEntityNbtToClient(CompoundTag tag, int identifier) {
        this.tag = tag;
        this.id = identifier;
    }

    public static void encode(SendEntityNbtToClient msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.tag);
        buf.writeInt(msg.id);
    }

    public static SendEntityNbtToClient decode(FriendlyByteBuf buf) {
        return new SendEntityNbtToClient(buf.m_130260_(), buf.readInt());
    }

    public static void handle(SendEntityNbtToClient msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> SendEntityNbtToClient.handle2(msg.tag, msg.id));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle2(CompoundTag tag, int id) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Entity entity = level.m_6815_(id);
        if (entity != null) {
            entity.getPersistentData().m_128391_(tag);
        }
    }
}

