/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.at.capability;

import com.pyding.at.network.PacketHandler;
import com.pyding.at.network.packets.SendPlayerCapaToClient;
import com.pyding.at.util.ATUtil;
import com.pyding.at.util.ConfigHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;

@AutoRegisterCapability
public class PlayerCapabilityAT {
    private int tier = 1;
    private int exp = 0;
    private String items = "";

    public void addItem(ItemStack stack, Player player) {
        String name;
        int rank = ATUtil.getTier(stack);
        if (rank > 0 && !player.m_20193_().f_46443_ && ATUtil.notContains(this.items, name = stack.m_41778_())) {
            this.items = this.items + name + ",";
            this.exp += rank;
            this.sync(player);
        }
    }

    public void clear(Player player) {
        this.items = "";
        this.exp = 0;
        this.tier = 1;
        this.sync(player);
    }

    public String getItems() {
        return this.items;
    }

    public void addTier(Player player) {
        this.tier = Math.min((Integer)ConfigHandler.COMMON.maxTier.get(), this.tier + 1);
        if (!player.m_20193_().f_46443_) {
            player.m_213846_((Component)Component.m_237110_((String)"at.give", (Object[])new Object[]{this.tier}));
        }
        this.sync(player);
    }

    public int getTier(Player player) {
        if (player.m_7500_() || player.m_5833_()) {
            return (Integer)ConfigHandler.COMMON.maxTier.get();
        }
        return this.tier;
    }

    public void setTier(Player player, int amount) {
        this.tier = amount;
        this.sync(player);
    }

    public void addExp(Player player) {
        ++this.exp;
        this.sync(player);
    }

    public int getExp() {
        return this.exp;
    }

    public void setExp(Player player, int amount) {
        this.exp = amount;
        this.sync(player);
    }

    public void copyNBT(PlayerCapabilityAT source) {
        this.tier = source.tier;
        this.exp = source.exp;
        this.items = source.items;
    }

    public void loadNBT(CompoundTag nbt) {
        this.tier = nbt.m_128451_("ATTiers");
        this.exp = nbt.m_128451_("ATExp");
        this.items = nbt.m_128461_("ATItems");
    }

    public void saveNBT(CompoundTag nbt) {
        nbt.m_128405_("ATTiers", this.tier);
        nbt.m_128405_("ATExp", this.exp);
        nbt.m_128359_("ATItems", this.items);
    }

    public void sync(Player player) {
        if (player.m_20193_().f_46443_) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        CompoundTag tag = new CompoundTag();
        this.saveNBT(tag);
        PacketHandler.sendToClient(new SendPlayerCapaToClient(tag), serverPlayer);
    }
}

