/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.at.event;

import com.mojang.brigadier.CommandDispatcher;
import com.pyding.at.capability.PlayerCapabilityAT;
import com.pyding.at.capability.PlayerCapabilityProviderAT;
import com.pyding.at.commands.ATCommands;
import com.pyding.at.compat.ATCompat;
import com.pyding.at.compat.ATCurio;
import com.pyding.at.util.ATUtil;
import com.pyding.at.util.ConfigHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="at")
public class EventHandler {
    @SubscribeEvent
    public void tooltipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        int tier = ATUtil.getTier(stack);
        if (tier > 0) {
            Player player;
            event.getToolTip().add(Component.m_237110_((String)"at.tier", (Object[])new Object[]{tier}).m_130940_(ATUtil.getColor(tier)));
            if (!ATUtil.notIgnored(stack)) {
                event.getToolTip().add(Component.m_237115_((String)"at.ignored").m_130940_(ATUtil.getColor(tier)));
            }
            if ((player = event.getEntity()) != null) {
                player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> {
                    event.getToolTip().add(Component.m_237110_((String)"at.get.tier", (Object[])new Object[]{cap.getTier(player)}).m_130940_(ATUtil.getColor(cap.getTier(player))));
                    if (((Boolean)ConfigHandler.COMMON.enableExp.get()).booleanValue()) {
                        event.getToolTip().add(Component.m_237110_((String)"at.tier.2", (Object[])new Object[]{cap.getExp(), ATUtil.getExpNext(cap.getTier(player))}).m_130940_(ATUtil.getColor(tier)));
                        if (ATUtil.notContains(cap.getItems(), stack.m_41778_())) {
                            String token = "";
                            if (ATCompat.jeiLoaded()) {
                                if (tier <= 10) {
                                    token = Component.m_237115_((String)("at.token." + tier)).getString();
                                } else {
                                    Random random = new Random(tier);
                                    StringBuilder result = new StringBuilder();
                                    for (int i = 0; i < 3; ++i) {
                                        char randomLetter = (char)(65 + random.nextInt(26));
                                        result.append(randomLetter);
                                    }
                                    token = result.toString();
                                }
                            }
                            event.getToolTip().add(Component.m_237110_((String)"at.discovered", (Object[])new Object[]{token}).m_130940_(ChatFormatting.GRAY));
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void eatEvent(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = event.getResultStack();
            player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> {
                int tier = ATUtil.getTier(stack);
                if (tier > cap.getTier(player) && ATUtil.notIgnored(stack)) {
                    event.setCanceled(true);
                    player.m_213846_((Component)Component.m_237110_((String)"at.chat.use", (Object[])new Object[]{tier}));
                }
            });
        }
    }

    @SubscribeEvent
    public static void useEvent(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> {
            int tier = ATUtil.getTier(stack);
            if (tier > cap.getTier(player) && ATUtil.notIgnored(stack)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.FAIL);
                player.m_213846_((Component)Component.m_237110_((String)"at.chat.use", (Object[])new Object[]{tier}));
            }
        });
    }

    @SubscribeEvent
    public static void tick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.f_19797_ % 20 == 0) {
                ATUtil.initMaps(player);
            }
            player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> {
                if (player.m_20193_().f_46443_) {
                    return;
                }
                if (player.f_19797_ % 20 == 0) {
                    cap.sync(player);
                }
                for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
                    ItemStack stack = (ItemStack)player.m_150109_().f_35975_.get(i);
                    if (ATUtil.getTier(stack) > cap.getTier(player) && ATUtil.notIgnored(stack)) {
                        player.m_36176_(stack, true);
                        player.m_150109_().f_35975_.set(i, (Object)ItemStack.f_41583_);
                        continue;
                    }
                    cap.addItem(stack, player);
                }
                if (ATCompat.curiosLoaded()) {
                    ATCurio.dropCurios(player, cap.getTier(player));
                }
                if (ATUtil.getTier(player.m_21206_()) > cap.getTier(player) && ATUtil.notIgnored(player.m_21206_())) {
                    ItemStack stack = player.m_21206_();
                    player.m_36176_(stack, true);
                    player.m_150109_().f_35976_.set(0, (Object)ItemStack.f_41583_);
                }
                float drop = ((Long)ConfigHandler.COMMON.timeToDrop.get()).longValue();
                if (player.f_19797_ % 20 == 0) {
                    if (drop > 0.0f) {
                        float time = player.getPersistentData().m_128454_("ATTime");
                        if (time == 0.0f) {
                            List<ItemStack> list = ATUtil.getAllItems(player);
                            boolean display = false;
                            for (ItemStack stack : list) {
                                if (ATUtil.getTier(stack) > cap.getTier(player) && ATUtil.notIgnored(stack)) {
                                    player.getPersistentData().m_128356_("ATTime", (long)((float)System.currentTimeMillis() + drop));
                                    display = true;
                                    continue;
                                }
                                cap.addItem(stack, player);
                            }
                            if (display) {
                                player.m_213846_((Component)Component.m_237110_((String)"at.chat.1", (Object[])new Object[]{(int)(drop / 1000.0f)}));
                            }
                        } else if (time > (float)System.currentTimeMillis()) {
                            player.m_213846_((Component)Component.m_237110_((String)"at.chat.1", (Object[])new Object[]{(int)((time - (float)System.currentTimeMillis()) / 1000.0f)}));
                        } else if (time <= (float)System.currentTimeMillis()) {
                            player.getPersistentData().m_128356_("ATTime", 0L);
                            List<ItemStack> list = ATUtil.getAllItems(player);
                            for (ItemStack stack : list) {
                                if (ATUtil.getTier(stack) > cap.getTier(player) && ATUtil.notIgnored(stack)) {
                                    player.m_150109_().m_36057_(stack);
                                    player.m_36176_(stack, true);
                                    continue;
                                }
                                cap.addItem(stack, player);
                            }
                        }
                    } else {
                        for (ItemStack stack : ATUtil.getAllItems(player)) {
                            if (ATUtil.getTier(stack) > cap.getTier(player) && ATUtil.notIgnored(stack)) continue;
                            cap.addItem(stack, player);
                        }
                    }
                }
                if (player.f_19797_ % 20 == 0 && cap.getExp() > 0 && cap.getExp() >= ATUtil.getExpNext(cap.getTier(player)) && ATUtil.getExpNext(cap.getTier(player)) > 0) {
                    cap.addTier(player);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void damageEventLowest(LivingDamageEvent event) {
        if (event.getSource() == null || event.getSource().m_7639_() == null) {
            return;
        }
        int maxTier = (Integer)ConfigHandler.COMMON.maxTier.get();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> {
                ItemStack stack = player.m_21205_();
                int tier = ATUtil.getTier(stack);
                if (cap.getTier(player) == maxTier) {
                    tier = maxTier;
                }
                int entityTier = ATUtil.getTier(event.getEntity());
                LivingEntity patt10075$temp = event.getEntity();
                if (patt10075$temp instanceof Player) {
                    Player dealerPlayer = (Player)patt10075$temp;
                    entityTier = 0;
                    if (cap.getTier(dealerPlayer) == maxTier) {
                        entityTier = maxTier;
                    } else {
                        for (ItemStack armor : dealerPlayer.m_150109_().f_35975_) {
                            entityTier += ATUtil.getTier(armor);
                        }
                        entityTier /= 4;
                    }
                } else if (tier < entityTier && player.getPersistentData().m_128454_("ATCd") < System.currentTimeMillis()) {
                    player.getPersistentData().m_128356_("ATCd", System.currentTimeMillis() + 10000L);
                    player.m_213846_((Component)Component.m_237110_((String)"at.chat.2", (Object[])new Object[]{entityTier}));
                }
                event.setAmount(ATUtil.calculateBonus(event.getAmount(), tier, entityTier, true));
            });
        } else {
            entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> {
                    int tier = 0;
                    if (cap.getTier(player) == maxTier) {
                        tier = maxTier;
                    } else {
                        for (ItemStack stack : player.m_150109_().f_35975_) {
                            tier += ATUtil.getTier(stack);
                        }
                        tier /= 4;
                    }
                    int entityTier = 0;
                    Entity patt11565$temp = event.getSource().m_7639_();
                    if (patt11565$temp instanceof Player) {
                        Player dealerPlayer = (Player)patt11565$temp;
                        entityTier = ATUtil.getTier(dealerPlayer.m_21205_());
                        if (cap.getTier(dealerPlayer) == maxTier) {
                            entityTier = maxTier;
                        }
                    } else {
                        Entity patt11864$temp = event.getSource().m_7639_();
                        if (patt11864$temp instanceof LivingEntity) {
                            LivingEntity entity = (LivingEntity)patt11864$temp;
                            entityTier = ATUtil.getTier(entity);
                        }
                    }
                    event.setAmount(ATUtil.calculateBonus(event.getAmount(), tier, entityTier, false));
                });
            } else {
                entity = event.getSource().m_7639_();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    event.setAmount(ATUtil.calculateBonus(event.getAmount(), ATUtil.getTier(livingEntity), ATUtil.getTier(event.getEntity()), true));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void attackEventLowest(LivingAttackEvent event) {
        Entity entity;
        if (event.getSource() != null && (entity = event.getSource().m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> {
                ItemStack stack = player.m_21120_(player.m_7655_());
                int tier = ATUtil.getTier(stack);
                if (tier > cap.getTier(player) && ATUtil.notIgnored(stack)) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> {
            int tier = ATUtil.getTier(player.m_20193_().m_8055_(event.getPos()).m_60734_());
            if (tier > ATUtil.getTier(player.m_21205_()) && cap.getTier(player) != ((Integer)ConfigHandler.COMMON.maxTier.get()).intValue()) {
                event.setCanceled(true);
                player.m_213846_((Component)Component.m_237110_((String)"at.chat.use", (Object[])new Object[]{tier}));
            } else if (!player.m_7500_()) {
                cap.addItem(player.m_20193_().m_8055_(event.getPos()).m_60734_().m_5456_().m_7968_(), player);
            }
        });
    }

    @SubscribeEvent
    public static void onPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> {
                int tier = ATUtil.getTier(event.getPlacedBlock().m_60734_());
                boolean ignored = false;
                if (event.getPlacedBlock().m_60734_().m_5456_() == player.m_21205_().m_41720_()) {
                    ignored = ATUtil.notIgnored(player.m_21205_());
                } else if (event.getPlacedBlock().m_60734_().m_5456_() == player.m_21206_().m_41720_()) {
                    ignored = ATUtil.notIgnored(player.m_21206_());
                }
                if (tier > cap.getTier(player) && ignored) {
                    event.setCanceled(true);
                    player.m_213846_((Component)Component.m_237110_((String)"at.chat.use", (Object[])new Object[]{tier}));
                }
            });
        }
    }

    @SubscribeEvent
    public static void useBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> {
            int tier = ATUtil.getTier(player.m_20193_().m_8055_(event.getPos()).m_60734_());
            if (tier > cap.getTier(player)) {
                event.setCanceled(true);
                player.m_213846_((Component)Component.m_237110_((String)"at.chat.use", (Object[])new Object[]{tier}));
            }
        });
    }

    @SubscribeEvent
    public static void interactEvent(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> {
            int tier = ATUtil.getTier(player.m_20193_().m_8055_(event.getPos()).m_60734_());
            if (tier > cap.getTier(player)) {
                event.setCanceled(true);
                player.m_213846_((Component)Component.m_237110_((String)"at.chat.use", (Object[])new Object[]{tier}));
            }
        });
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        ATCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void capabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
            event.addCapability(new ResourceLocation("at", "properties"), (ICapabilityProvider)new PlayerCapabilityProviderAT());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(oldStore -> event.getEntity().getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(newStore -> {
            newStore.copyNBT((PlayerCapabilityAT)oldStore);
            newStore.sync(event.getEntity());
        }));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void spawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> cap.sync(player));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void loginIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> cap.sync(player));
        ATUtil.syncData(player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void loginOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        player.getCapability(PlayerCapabilityProviderAT.playerCap).ifPresent(cap -> cap.sync(player));
    }
}

