/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.at.network.packets;

import com.pyding.at.util.ATUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class HashMapClient {
    private String map;
    private int id;

    public HashMapClient(String map, int id) {
        this.map = map;
        this.id = id;
    }

    public static void encode(HashMapClient msg, FriendlyByteBuf buf) {
        byte[] data = msg.map.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(data.length);
        buf.m_130087_(data);
        buf.writeInt(msg.id);
    }

    public static HashMapClient decode(FriendlyByteBuf buf) {
        int length = buf.readInt();
        byte[] data = buf.m_130101_(length);
        String map = new String(data, StandardCharsets.UTF_8);
        int id = buf.readInt();
        return new HashMapClient(map, id);
    }

    public static void handle(HashMapClient msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> HashMapClient.handle2(msg.map, msg.id));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle2(String map, int id) {
        if (id == 1) {
            ATUtil.initMap(map, ATUtil.itemTiers, true);
        } else if (id == 2) {
            ATUtil.initMap(map, ATUtil.entityTiers, false);
            ATUtil.getItems();
        }
    }
}

