/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.at.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SendPlayerNbtToClient {
    private UUID playerID;
    private CompoundTag tag;

    public SendPlayerNbtToClient(UUID playerID, CompoundTag tag) {
        this.playerID = playerID;
        this.tag = tag;
    }

    public static void encode(SendPlayerNbtToClient msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.playerID);
        buf.m_130079_(msg.tag);
    }

    public static SendPlayerNbtToClient decode(FriendlyByteBuf buf) {
        return new SendPlayerNbtToClient(buf.m_130259_(), buf.m_130260_());
    }

    public static void handle(SendPlayerNbtToClient msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> SendPlayerNbtToClient.handle2(msg.playerID, msg.tag));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle2(UUID playerID, CompoundTag tag) {
        Minecraft.m_91087_().f_91073_.m_6907_().stream().filter(player -> player.m_20148_().equals(playerID)).findAny().ifPresent(player -> player.getPersistentData().m_128391_(tag));
    }
}

