/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.at.util;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue maxTier;
        public final ForgeConfigSpec.BooleanValue creativeMax;
        public final ForgeConfigSpec.BooleanValue enableExp;
        public final ForgeConfigSpec.DoubleValue startingExpPercent;
        public final ForgeConfigSpec.IntValue damagePercentBonus;
        public final ForgeConfigSpec.IntValue durabilityPercentBonus;
        public final ForgeConfigSpec.IntValue armorPercentBonus;
        public final ForgeConfigSpec.IntValue attackPercentBonus;
        public final ForgeConfigSpec.LongValue timeToDrop;
        public final ForgeConfigSpec.DoubleValue minimumDamage;
        public final ForgeConfigSpec.ConfigValue itemTiers;
        public final ForgeConfigSpec.ConfigValue entityTiers;
        public final ForgeConfigSpec.ConfigValue blockTiers;

        public Common(ForgeConfigSpec.Builder builder) {
            this.maxTier = builder.comment("Defines maximum Tier value.").defineInRange("maxTier", 10, 1, 2100000000);
            this.creativeMax = builder.comment("Enables max Tier in Creative.").define("creativeMax", true);
            this.enableExp = builder.comment("Enables exp system to lvl up Tier.").define("enableExp", true);
            this.startingExpPercent = builder.comment("Percentage for second Tier and higher.").defineInRange("startingExpPercent", 0.3, 0.01, 1.0);
            this.itemTiers = builder.comment("Tiers for Items: ").define("itemTiers", (Object)"");
            this.entityTiers = builder.comment("Tiers for Entities: ").define("entityTiers", (Object)"");
            this.blockTiers = builder.comment("Tiers for Blocks: ").define("blockTiers", (Object)"");
            this.timeToDrop = builder.comment("Time until items with higher Tier will drop from player. Set to 0 to disable.").defineInRange("timeToDrop", 5000L, 0L, Long.MAX_VALUE);
            this.minimumDamage = builder.comment("Minimum damage that higher Tier entity receives.").defineInRange("minimumDamage", 0.1, 0.0, 3.4028234663852886E38);
            this.damagePercentBonus = builder.comment("Maximum bonus from max Tier tool damage dealt to Tier 1 creature. Works reverse also.").defineInRange("damagePercentBonus", 400, 1, 2100000000);
            this.durabilityPercentBonus = builder.comment("Maximum durability bonus for Max Tier.").defineInRange("durabilityPercentBonus", 150, 1, 2100000000);
            this.armorPercentBonus = builder.comment("Maximum armor bonus for Max Tier.").defineInRange("armorPercentBonus", 150, 1, 2100000000);
            this.attackPercentBonus = builder.comment("Maximum damage bonus for Max Tier.").defineInRange("attackPercentBonus", 200, 1, 2100000000);
        }
    }
}

