/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.EasyVillagersMod;
import de.maxhenkel.easyvillagers.blocks.ConverterBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.VillagerConvertSlot;
import de.maxhenkel.easyvillagers.inventory.InputOnlyResourceHandler;
import de.maxhenkel.easyvillagers.inventory.ListAccessItemStacksResourceHandler;
import de.maxhenkel.easyvillagers.inventory.OutputOnlyResourceHandler;
import de.maxhenkel.easyvillagers.inventory.ValidateResourceHandler;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.CombinedResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class ConverterTileentity
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected ValidateResourceHandler inputInventory = new ValidateResourceHandler(4, VillagerConvertSlot::isValid);
    protected ListAccessItemStacksResourceHandler outputInventory = new ListAccessItemStacksResourceHandler(4);
    protected long timer;
    protected UUID owner;
    protected CombinedResourceHandler<ItemResource> itemHandler = new CombinedResourceHandler(new ResourceHandler[]{new InputOnlyResourceHandler((ResourceHandler<ItemResource>)this.inputInventory), new OutputOnlyResourceHandler((ResourceHandler<ItemResource>)this.outputInventory)});

    public ConverterTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.CONVERTER.get(), ((ConverterBlock)((Object)ModBlocks.CONVERTER.get())).defaultBlockState(), pos, state);
    }

    @Override
    public void tickServer() {
        int i;
        block22: {
            if (this.timer <= 0L && !this.hasVillager()) {
                try (Transaction transaction = Transaction.open(null);){
                    if (!this.consumeConvertItems((TransactionContext)transaction)) break block22;
                    for (i = 0; i < this.inputInventory.size(); ++i) {
                        ItemResource resource = (ItemResource)this.inputInventory.getResource(i);
                        if (!(resource.getItem() instanceof VillagerItem) || this.inputInventory.extract((Resource)resource, 1, (TransactionContext)transaction) <= 0) continue;
                        ItemStack copy = resource.toStack();
                        copy.setCount(1);
                        this.setVillager(copy);
                        this.sync();
                        transaction.commit();
                        break;
                    }
                }
            }
        }
        if (this.hasVillager()) {
            Player ownerPlayer;
            if (this.advanceAge()) {
                this.sync();
            }
            if (this.timer == (long)ConverterTileentity.getZombifyTime()) {
                VillagerBlockBase.playVillagerSound(this.level, this.worldPosition, SoundEvents.ZOMBIE_INFECT);
                this.sync();
            } else if (this.timer == (long)ConverterTileentity.getCureTime()) {
                VillagerBlockBase.playVillagerSound(this.level, this.worldPosition, SoundEvents.ZOMBIE_VILLAGER_CURE);
                this.sync();
            } else if (this.timer == (long)ConverterTileentity.getConvertTime()) {
                VillagerBlockBase.playVillagerSound(this.level, this.worldPosition, SoundEvents.ZOMBIE_VILLAGER_CONVERTED);
                this.sync();
            } else if (this.timer >= (long)ConverterTileentity.getFinalizeTime() && (ownerPlayer = this.getOwnerPlayer()) != null) {
                for (i = 0; i < this.outputInventory.size(); ++i) {
                    ItemResource stack = (ItemResource)this.outputInventory.getResource(i);
                    if (!stack.isEmpty()) continue;
                    EasyVillagerEntity villagerEntity = this.getVillagerEntity();
                    villagerEntity.onReputationEventFrom(ReputationEventType.ZOMBIE_VILLAGER_CURED, (Entity)ownerPlayer);
                    this.outputInventory.set(i, (Resource)ItemResource.of((ItemStack)this.removeVillager().copy()), 1);
                    this.timer = 0L;
                    this.sync();
                    break;
                }
            }
            ++this.timer;
            this.setChanged();
            if (this.timer < (long)ConverterTileentity.getZombifyTime() || this.timer >= (long)ConverterTileentity.getConvertTime()) {
                VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
            } else {
                VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.ZOMBIE_VILLAGER_AMBIENT);
            }
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.ZOMBIE_AMBIENT);
        } else if (this.timer != 0L) {
            this.timer = 0L;
            this.setChanged();
        }
    }

    private boolean consumeConvertItems(TransactionContext transaction) {
        ItemResource appleStack = null;
        ItemResource potionStack = null;
        for (int i = 0; i < this.inputInventory.size(); ++i) {
            ItemResource resource = (ItemResource)this.inputInventory.getResource(i);
            if (resource.getItem() == Items.GOLDEN_APPLE) {
                appleStack = resource;
            }
            if (!ConverterTileentity.isWeakness(resource)) continue;
            potionStack = resource;
        }
        if (appleStack == null || potionStack == null) {
            return false;
        }
        if (this.inputInventory.extract((Resource)appleStack, 1, transaction) <= 0) {
            return false;
        }
        return this.inputInventory.extract((Resource)potionStack, 1, transaction) > 0;
    }

    public static boolean isWeakness(ItemResource stack) {
        PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potionContents == null) {
            return false;
        }
        return potionContents.potion().filter(potionHolder -> potionHolder.equals((Object)Potions.WEAKNESS) || potionHolder.equals((Object)Potions.LONG_WEAKNESS)).isPresent();
    }

    public long getTimer() {
        return this.timer;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Player getOwnerPlayer() {
        if (this.owner == null) {
            return null;
        }
        if (this.level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)this.level;
            return serverWorld.getServer().getPlayerList().getPlayer(this.owner);
        }
        return this.level.getPlayerByUUID(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ItemUtils.saveInventory(valueOutput.child("InputInventory"), "Items", this.inputInventory.getRaw());
        ItemUtils.saveInventory(valueOutput.child("OutputInventory"), "Items", this.outputInventory.getRaw());
        valueOutput.putLong("Timer", this.timer);
        if (this.owner != null) {
            valueOutput.store("Owner", UUIDUtil.CODEC, (Object)this.owner);
        }
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        ItemUtils.readInventory(valueInput.childOrEmpty("InputInventory"), "Items", this.inputInventory.getRaw());
        ItemUtils.readInventory(valueInput.childOrEmpty("OutputInventory"), "Items", this.outputInventory.getRaw());
        this.timer = valueInput.getLongOr("Timer", 0L);
        this.owner = valueInput.read("Owner", UUIDUtil.CODEC).orElse(null);
        super.loadAdditional(valueInput);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory.getRaw(), () -> ((ConverterTileentity)this).setChanged());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory.getRaw(), () -> ((ConverterTileentity)this).setChanged());
    }

    public static int getZombifyTime() {
        return 60;
    }

    public static int getCureTime() {
        return ConverterTileentity.getZombifyTime() + 60;
    }

    public static int getConvertTime() {
        return ConverterTileentity.getCureTime() + (Integer)EasyVillagersMod.SERVER_CONFIG.convertingTime.get();
    }

    public static int getFinalizeTime() {
        return ConverterTileentity.getConvertTime() + 60;
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.itemHandler;
    }
}

