/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.TraderRenderState;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import de.maxhenkel.easyvillagers.corelib.CachedMap;
import de.maxhenkel.easyvillagers.corelib.client.RenderUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public abstract class TraderRendererBase<T extends TraderTileentityBase>
extends VillagerRendererBase<T, TraderRenderState> {
    private static final CachedMap<Block, BlockState> blockStateCache = new CachedMap(10000L);
    private final BlockRenderDispatcher blockRenderer;
    public static final Map<ResourceLocation, Consumer<PoseStack>> TRANSFORMS = new HashMap<ResourceLocation, Consumer<PoseStack>>();
    private static final Map<Block, Consumer<PoseStack>> TRANSFORMS_CACHE = new HashMap<Block, Consumer<PoseStack>>();
    public static final Map<ResourceLocation, ResourceLocation> TOP_BLOCKS = new HashMap<ResourceLocation, ResourceLocation>();
    private static final Map<Block, BlockState> TOP_BLOCK_CACHE = new HashMap<Block, BlockState>();

    public TraderRendererBase(EntityModelSet entityModelSet, BlockRenderDispatcher blockRenderer) {
        super(entityModelSet);
        this.blockRenderer = blockRenderer;
    }

    public TraderRenderState createRenderState() {
        return new TraderRenderState();
    }

    public void extractRenderState(T trader, TraderRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(trader, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        state.apply((VillagerTileentity)((Object)trader));
        state.renderVillager = false;
        if (((VillagerTileentity)((Object)trader)).getVillagerEntity() != null) {
            state.renderVillager = true;
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.extractRenderState((Villager)((VillagerTileentity)((Object)trader)).getVillagerEntity(), state.villagerRenderState, partialTicks);
            state.villagerRenderState.lightCoords = TraderRendererBase.getLightOrDefault(trader, state);
        }
        state.workstation = ((TraderTileentityBase)trader).hasWorkstation() ? TraderRendererBase.getState(((TraderTileentityBase)trader).getWorkstation()) : null;
    }

    public void submit(TraderRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        TraderRendererBase.submitTraderBase(this.getVillagerRenderer(), this.blockRenderer, state, stack, collector, cameraRenderState);
    }

    public static void submitTraderBase(VillagerRenderer villagerRenderer, BlockRenderDispatcher blockRenderer, TraderRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        stack.pushPose();
        if (state.renderVillager) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
            stack.translate(0.0, 0.0, -0.25);
            stack.scale(0.45f, 0.45f, 0.45f);
            villagerRenderer.submit((LivingEntityRenderState)state.villagerRenderState, stack, collector, cameraRenderState);
            stack.popPose();
        }
        if (state.workstation != null) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
            stack.translate(0.0, 0.0, 0.125);
            stack.translate(-0.5, 0.0, -0.5);
            stack.scale(0.45f, 0.45f, 0.45f);
            stack.translate(0.6111111111111112, 0.0, 0.6111111111111112);
            TraderRendererBase.getTransforms(state.workstation).accept(stack);
            TraderRendererBase.renderBlock(blockRenderer, state.workstation, state.lightCoords, stack, collector);
            BlockState topBlock = TraderRendererBase.getTopBlock(state.workstation);
            if (!topBlock.isAir()) {
                stack.translate(0.0, 1.0, 0.0);
                TraderRendererBase.renderBlock(blockRenderer, topBlock, state.lightCoords, stack, collector);
            }
            stack.popPose();
        }
        stack.popPose();
    }

    public static void renderBlock(BlockRenderDispatcher blockRenderer, BlockState state, int lightCoords, PoseStack stack, SubmitNodeCollector collector) {
        int color = minecraft.getBlockColors().getColor(state, null, null, 0);
        collector.submitBlockModel(stack, RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), blockRenderer.getBlockModel(state), RenderUtils.getRedFloat(color), RenderUtils.getGreenFloat(color), RenderUtils.getBlueFloat(color), lightCoords, OverlayTexture.NO_OVERLAY, 0);
    }

    public static BlockState getState(Block block) {
        return blockStateCache.get(block, () -> TraderRendererBase.getFittingState(block));
    }

    protected static BlockState getFittingState(Block block) {
        if (block == Blocks.GRINDSTONE) {
            return (BlockState)block.defaultBlockState().setValue((Property)GrindstoneBlock.FACE, (Comparable)AttachFace.FLOOR);
        }
        return block.defaultBlockState();
    }

    protected static Consumer<PoseStack> getTransforms(BlockState block) {
        Consumer<PoseStack> cached = TRANSFORMS_CACHE.get(block.getBlock());
        if (cached != null) {
            return cached;
        }
        Consumer<PoseStack> transform = TRANSFORMS.get(BuiltInRegistries.BLOCK.getKey((Object)block.getBlock()));
        if (transform == null) {
            transform = stack -> {};
        }
        TRANSFORMS_CACHE.put(block.getBlock(), transform);
        return transform;
    }

    protected static BlockState getTopBlock(BlockState bottom) {
        BlockState cached = TOP_BLOCK_CACHE.get(bottom.getBlock());
        if (cached != null) {
            return cached;
        }
        ResourceLocation resourceLocation = TOP_BLOCKS.get(BuiltInRegistries.BLOCK.getKey((Object)bottom.getBlock()));
        if (resourceLocation == null) {
            BlockState state = Blocks.AIR.defaultBlockState();
            TOP_BLOCK_CACHE.put(bottom.getBlock(), state);
            return state;
        }
        if (!BuiltInRegistries.BLOCK.containsKey(resourceLocation)) {
            BlockState state = Blocks.AIR.defaultBlockState();
            TOP_BLOCK_CACHE.put(bottom.getBlock(), state);
            return state;
        }
        Block b = BuiltInRegistries.BLOCK.get(resourceLocation).map(Holder.Reference::value).orElse(Blocks.AIR);
        BlockState state = b.defaultBlockState();
        TOP_BLOCK_CACHE.put(bottom.getBlock(), state);
        return state;
    }

    static {
        Consumer<PoseStack> immersiveEngineering = stack -> stack.translate(-0.5, 0.0, 0.0);
        TRANSFORMS.put(ResourceLocation.fromNamespaceAndPath((String)"immersiveengineering", (String)"workbench"), immersiveEngineering);
        TRANSFORMS.put(ResourceLocation.fromNamespaceAndPath((String)"immersiveengineering", (String)"circuit_table"), immersiveEngineering);
        TOP_BLOCKS.put(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"gas_station"), ResourceLocation.fromNamespaceAndPath((String)"car", (String)"gas_station_top"));
    }
}

