/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.gui;

import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class VillagerArmorContainer
implements Container {
    private static final EquipmentSlot[] SLOTS = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    private final EasyVillagerEntity villager;
    private final Runnable onMarkDirty;

    public VillagerArmorContainer(EasyVillagerEntity villager, Runnable onMarkDirty) {
        this.villager = villager;
        this.onMarkDirty = onMarkDirty;
    }

    public int getContainerSize() {
        return SLOTS.length;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int i) {
        return this.villager.getItemBySlot(SLOTS[i]);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack item = this.villager.getItemBySlot(SLOTS[index]);
        if (item.isEmpty() || count < 0) {
            return ItemStack.EMPTY;
        }
        ItemStack result = item.split(count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    public ItemStack removeItemNoUpdate(int i) {
        ItemStack item = this.getItem(i);
        this.setItem(i, ItemStack.EMPTY);
        return item;
    }

    public void setItem(int i, ItemStack stack) {
        this.villager.setItemSlot(SLOTS[i], stack);
    }

    public void setChanged() {
        this.onMarkDirty.run();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
    }
}

