/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.EasyVillagersMod;
import de.maxhenkel.easyvillagers.blocks.AutoTraderBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.inventory.InputOnlyResourceHandler;
import de.maxhenkel.easyvillagers.inventory.ListAccessItemStacksResourceHandler;
import de.maxhenkel.easyvillagers.inventory.OutputOnlyResourceHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.CombinedResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class AutoTraderTileentity
extends TraderTileentityBase
implements ITickableBlockEntity {
    protected Container tradeGuiInv = new SimpleContainer(3);
    protected final ListAccessItemStacksResourceHandler inputInventory = new ListAccessItemStacksResourceHandler(4);
    protected final ListAccessItemStacksResourceHandler outputInventory = new ListAccessItemStacksResourceHandler(4);
    protected int tradeIndex;
    protected CombinedResourceHandler<ItemResource> itemHandler = new CombinedResourceHandler(new ResourceHandler[]{new InputOnlyResourceHandler((ResourceHandler<ItemResource>)this.inputInventory), new OutputOnlyResourceHandler((ResourceHandler<ItemResource>)this.outputInventory)});

    public AutoTraderTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.AUTO_TRADER.get(), ((AutoTraderBlock)((Object)ModBlocks.AUTO_TRADER.get())).defaultBlockState(), pos, state);
    }

    @Override
    public void tick() {
        if (!this.hasVillager()) {
            return;
        }
        if (this.level.getGameTime() % (long)((Integer)EasyVillagersMod.SERVER_CONFIG.autoTraderCooldown.get()).intValue() != 0L) {
            return;
        }
        MerchantOffer offer = this.getOffer();
        if (offer == null || offer.isOutOfStock() || ResourceHandlerUtil.isEmpty((ResourceHandler)this.inputInventory)) {
            return;
        }
        try (Transaction transaction = Transaction.open(null);){
            if (!this.removeNeededItems(this.getAutoTradeInputA(), (TransactionContext)transaction)) {
                return;
            }
            if (!this.removeNeededItems(offer.getCostB(), (TransactionContext)transaction)) {
                return;
            }
            if (!this.insertItems(offer.getResult(), (TransactionContext)transaction)) {
                return;
            }
            transaction.commit();
        }
        EasyVillagerEntity villager = this.getVillagerEntity();
        offer.increaseUses();
        villager.setVillagerXp(villager.getVillagerXp() + offer.getXp());
        if (villager.shouldIncreaseLevel()) {
            villager.increaseProfessionLevelOnUpdate = true;
        }
        this.setChanged();
    }

    protected boolean removeNeededItems(ItemStack buying, TransactionContext transaction) {
        if (buying.isEmpty()) {
            return true;
        }
        int extract = this.inputInventory.extract((Resource)ItemResource.of((ItemStack)buying), buying.getCount(), transaction);
        return extract >= buying.getCount();
    }

    protected boolean insertItems(ItemStack insert, TransactionContext transaction) {
        if (insert.isEmpty()) {
            return true;
        }
        return this.outputInventory.insert((Resource)ItemResource.of((ItemStack)insert), insert.getCount(), transaction) >= insert.getCount();
    }

    public Container getTradeGuiInv() {
        this.updateTradeInv();
        return this.tradeGuiInv;
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
        this.updateTradeInv();
        this.setChanged();
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        this.updateTradeInv();
    }

    @Override
    public void setWorkstation(Block workstation) {
        super.setWorkstation(workstation);
        this.updateTradeInv();
    }

    public void nextTrade() {
        int tradeCount = this.getTradeCount();
        if (tradeCount > 0) {
            this.setTradeIndex(Math.floorMod(this.tradeIndex + 1, tradeCount));
        }
    }

    public void prevTrade() {
        int tradeCount = this.getTradeCount();
        if (tradeCount > 0) {
            this.setTradeIndex(Math.floorMod(this.tradeIndex - 1, tradeCount));
        }
    }

    protected void updateTradeInv() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            this.tradeGuiInv.clearContent();
            return;
        }
        villagerEntity.recalculateOffers();
        MerchantOffer offer = this.getOffer();
        if (offer == null) {
            this.tradeGuiInv.clearContent();
            return;
        }
        this.tradeGuiInv.setItem(0, this.getAutoTradeInputA());
        this.tradeGuiInv.setItem(1, offer.getCostB());
        this.tradeGuiInv.setItem(2, offer.getResult());
    }

    public ItemStack getAutoTradeInputA() {
        MerchantOffer offer = this.getOffer();
        if (offer == null) {
            return ItemStack.EMPTY;
        }
        ItemStack costA = offer.getCostA().copy();
        int amount = Math.min(costA.getCount(), offer.getBaseCostA().getCount());
        costA.setCount(amount);
        return costA;
    }

    @Nullable
    public MerchantOffer getOffer() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return null;
        }
        if (villagerEntity.level().isClientSide()) {
            return null;
        }
        MerchantOffers offers = villagerEntity.getOffers();
        if (this.tradeIndex < 0 || this.tradeIndex >= offers.size()) {
            return null;
        }
        return (MerchantOffer)offers.get(this.tradeIndex);
    }

    protected int getTradeCount() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return 0;
        }
        return villagerEntity.getOffers().size();
    }

    @Override
    protected long calculateNextRestock() {
        return (Integer)EasyVillagersMod.SERVER_CONFIG.autoTraderMinRestockTime.get() + this.level.random.nextInt(Math.max((Integer)EasyVillagersMod.SERVER_CONFIG.autoTraderMaxRestockTime.get() - (Integer)EasyVillagersMod.SERVER_CONFIG.autoTraderMinRestockTime.get(), 1));
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putInt("Trade", this.tradeIndex);
        ItemUtils.saveInventory(valueOutput.child("InputInventory"), "Items", this.inputInventory.getRaw());
        ItemUtils.saveInventory(valueOutput.child("OutputInventory"), "Items", this.outputInventory.getRaw());
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.tradeIndex = valueInput.getIntOr("Trade", 0);
        ItemUtils.readInventory(valueInput.childOrEmpty("InputInventory"), "Items", this.inputInventory.getRaw());
        ItemUtils.readInventory(valueInput.childOrEmpty("OutputInventory"), "Items", this.outputInventory.getRaw());
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory.getRaw(), () -> ((AutoTraderTileentity)this).setChanged());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory.getRaw(), () -> ((AutoTraderTileentity)this).setChanged());
    }

    public CombinedResourceHandler<ItemResource> getItemHandler() {
        return this.itemHandler;
    }
}

