/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.EasyVillagersMod;
import de.maxhenkel.easyvillagers.blocks.IncubatorBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.VillagerIncubateSlot;
import de.maxhenkel.easyvillagers.inventory.InputOnlyResourceHandler;
import de.maxhenkel.easyvillagers.inventory.ListAccessItemStacksResourceHandler;
import de.maxhenkel.easyvillagers.inventory.OutputOnlyResourceHandler;
import de.maxhenkel.easyvillagers.inventory.ValidateResourceHandler;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.CombinedResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class IncubatorTileentity
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected ValidateResourceHandler inputInventory = new ValidateResourceHandler(4, VillagerIncubateSlot::isValid);
    protected ListAccessItemStacksResourceHandler outputInventory = new ListAccessItemStacksResourceHandler(4);
    protected CombinedResourceHandler<ItemResource> itemHandler = new CombinedResourceHandler(new ResourceHandler[]{new InputOnlyResourceHandler((ResourceHandler<ItemResource>)this.inputInventory), new OutputOnlyResourceHandler((ResourceHandler<ItemResource>)this.outputInventory)});

    public IncubatorTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.INCUBATOR.get(), ((IncubatorBlock)((Object)ModBlocks.INCUBATOR.get())).defaultBlockState(), pos, state);
    }

    @Override
    public void tickServer() {
        if (!this.hasVillager()) {
            try (Transaction transaction = Transaction.open(null);){
                for (int i = 0; i < this.inputInventory.size(); ++i) {
                    ItemResource resource = (ItemResource)this.inputInventory.getResource(i);
                    if (!(resource.getItem() instanceof VillagerItem)) continue;
                    this.inputInventory.extract((Resource)resource, 1, (TransactionContext)transaction);
                    this.setVillager(resource.toStack());
                    transaction.commit();
                    this.sync();
                    break;
                }
            }
        }
        if (this.hasVillager()) {
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
            EasyVillagerEntity villagerEntity = this.getVillagerEntity();
            if (villagerEntity.isBaby()) {
                if (this.advanceAge(Math.min((Integer)EasyVillagersMod.SERVER_CONFIG.incubatorSpeed.get(), Math.abs(villagerEntity.getAge())))) {
                    this.sync();
                }
            } else {
                this.advanceAge(1);
            }
            if (villagerEntity.getAge() > 20) {
                ItemStack villagerItem = this.getVillager();
                try (Transaction transaction = Transaction.open(null);){
                    if (this.outputInventory.insert((Resource)ItemResource.of((ItemStack)villagerItem), 1, (TransactionContext)transaction) > 0) {
                        this.removeVillager();
                        transaction.commit();
                        this.sync();
                    }
                }
            }
        }
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ItemUtils.saveInventory(valueOutput.child("InputInventory"), "Items", this.inputInventory.getRaw());
        ItemUtils.saveInventory(valueOutput.child("OutputInventory"), "Items", this.outputInventory.getRaw());
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        ItemUtils.readInventory(valueInput.childOrEmpty("InputInventory"), "Items", this.inputInventory.getRaw());
        ItemUtils.readInventory(valueInput.childOrEmpty("OutputInventory"), "Items", this.outputInventory.getRaw());
        super.loadAdditional(valueInput);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory.getRaw(), () -> ((IncubatorTileentity)this).setChanged());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory.getRaw(), () -> ((IncubatorTileentity)this).setChanged());
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.itemHandler;
    }
}

