/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.tileentity.InventoryViewerTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.InventoryViewerRenderState;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class InventoryViewerRenderer
extends VillagerRendererBase<InventoryViewerTileentity, InventoryViewerRenderState> {
    public InventoryViewerRenderer(EntityModelSet entityModelSet) {
        super(entityModelSet);
    }

    public InventoryViewerRenderState createRenderState() {
        return new InventoryViewerRenderState();
    }

    public void extractRenderState(InventoryViewerTileentity inventoryViewer, InventoryViewerRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)inventoryViewer, (BlockEntityRenderState)state, partialTicks, pos, overlay);
        state.apply(inventoryViewer);
        state.renderVillager = false;
        if (inventoryViewer.getVillagerEntity() != null) {
            state.renderVillager = true;
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.extractRenderState((Villager)inventoryViewer.getVillagerEntity(), state.villagerRenderState, partialTicks);
            state.villagerRenderState.lightCoords = InventoryViewerRenderer.getLightOrDefault(inventoryViewer, state);
        }
    }

    public void submit(InventoryViewerRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        stack.pushPose();
        if (state.renderVillager) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
            stack.scale(0.45f, 0.45f, 0.45f);
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.submit((LivingEntityRenderState)state.villagerRenderState, stack, collector, cameraRenderState);
            stack.popPose();
        }
        stack.popPose();
    }
}

