/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.tileentity.IncubatorTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.IncubatorRenderState;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class IncubatorRenderer
extends VillagerRendererBase<IncubatorTileentity, IncubatorRenderState> {
    public IncubatorRenderer(EntityModelSet entityModelSet) {
        super(entityModelSet);
    }

    public IncubatorRenderState createRenderState() {
        return new IncubatorRenderState();
    }

    public void extractRenderState(IncubatorTileentity incubator, IncubatorRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)incubator, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        state.apply(incubator);
        state.renderVillager = false;
        if (incubator.getVillagerEntity() != null) {
            state.renderVillager = true;
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.extractRenderState((Villager)incubator.getVillagerEntity(), state.villagerRenderState, partialTicks);
            state.villagerRenderState.lightCoords = IncubatorRenderer.getLightOrDefault(incubator, state);
        }
    }

    public void submit(IncubatorRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        stack.pushPose();
        if (state.renderVillager) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
            stack.scale(0.45f, 0.45f, 0.45f);
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.submit((LivingEntityRenderState)state.villagerRenderState, stack, collector, cameraRenderState);
            stack.popPose();
        }
        stack.popPose();
    }
}

