/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easyvillagers.datacomponents.VillagerData;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class VillagerTileentity
extends FakeWorldTileentity {
    protected ItemStack villager = ItemStack.EMPTY;
    protected EasyVillagerEntity villagerEntity;

    public VillagerTileentity(BlockEntityType<?> type, BlockState defaultState, BlockPos pos, BlockState state) {
        super(type, defaultState, pos, state);
    }

    public ItemStack getVillager() {
        if (this.villagerEntity != null) {
            this.saveVillagerEntity();
        }
        return this.villager;
    }

    public boolean hasVillager() {
        return !this.villager.isEmpty();
    }

    @Nullable
    public EasyVillagerEntity getVillagerEntity() {
        if (this.villagerEntity == null && !this.villager.isEmpty()) {
            this.villagerEntity = VillagerData.createEasyVillager(this.villager, this.level);
        }
        return this.villagerEntity;
    }

    public void saveVillagerEntity() {
        if (this.villagerEntity != null) {
            VillagerData.applyToItem(this.villager, this.villagerEntity);
        }
    }

    public void setVillager(ItemStack villager) {
        this.villager = villager;
        this.removeTradingPlayer();
        if (villager.isEmpty()) {
            this.villagerEntity = null;
        } else {
            this.villagerEntity = VillagerData.createEasyVillager(villager, this.level);
            this.onAddVillager(this.villagerEntity);
        }
        this.setChanged();
        this.sync();
    }

    public void removeTradingPlayer() {
        if (this.villagerEntity != null) {
            this.villagerEntity.setTradingPlayer(null);
        }
    }

    protected void onAddVillager(EasyVillagerEntity villager) {
    }

    public ItemStack removeVillager() {
        ItemStack v = this.getVillager();
        this.setVillager(ItemStack.EMPTY);
        return v;
    }

    public boolean advanceAge() {
        return VillagerTileentity.advanceAge(this.getVillagerEntity());
    }

    public boolean advanceAge(int amount) {
        return VillagerTileentity.advanceAge(this.getVillagerEntity(), amount);
    }

    public static boolean advanceAge(EasyVillagerEntity villagerEntity, int amount) {
        if (villagerEntity == null) {
            return false;
        }
        int prevAge = villagerEntity.getAge();
        int age = prevAge + amount;
        villagerEntity.setAge(age);
        return prevAge < 0 && age >= 0;
    }

    public static boolean advanceAge(EasyVillagerEntity villagerEntity) {
        return VillagerTileentity.advanceAge(villagerEntity, 1);
    }

    public void setRemoved() {
        this.removeTradingPlayer();
        super.setRemoved();
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        if (this.hasVillager()) {
            valueOutput.store("Villager", ItemStack.CODEC, (Object)this.getVillager());
        }
    }

    protected void loadAdditional(ValueInput valueInput) {
        Optional optionalItemStack = valueInput.read("Villager", ItemStack.CODEC);
        if (optionalItemStack.isPresent()) {
            this.villager = (ItemStack)optionalItemStack.get();
            this.villagerEntity = null;
        } else {
            this.removeVillager();
        }
        super.loadAdditional(valueInput);
    }
}

