/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.corelib.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ResolvableProfile;

public class PlayerSkins {
    private static final Map<UUID, ResolvableProfile> PLAYERS = new ConcurrentHashMap<UUID, ResolvableProfile>();

    public static PlayerSkin getSkin(UUID uuid) {
        return PlayerSkins.getSkin(PlayerSkins.getGameProfile(uuid));
    }

    public static PlayerSkin getSkin(Player player) {
        return PlayerSkins.getSkin(player.getGameProfile());
    }

    public static PlayerSkin getSkin(GameProfile gameProfile) {
        return Minecraft.getInstance().getSkinManager().getInsecureSkin(gameProfile);
    }

    public static GameProfile getGameProfile(UUID uuid) {
        if (PLAYERS.containsKey(uuid)) {
            return PLAYERS.get(uuid).gameProfile();
        }
        ResolvableProfile resolvableProfile = new ResolvableProfile(Optional.empty(), Optional.ofNullable(uuid), new PropertyMap());
        PLAYERS.put(uuid, resolvableProfile);
        if (!resolvableProfile.isResolved()) {
            resolvableProfile.resolve().thenAcceptAsync(profile -> PLAYERS.put(uuid, (ResolvableProfile)profile), (Executor)Minecraft.getInstance());
        }
        return resolvableProfile.gameProfile();
    }

    public static boolean isSlim(UUID uuid) {
        return PlayerSkin.Model.SLIM.equals((Object)PlayerSkins.getSkin(uuid).model());
    }

    public static boolean isSlim(Player player) {
        return PlayerSkins.isSlim(player.getUUID());
    }
}

