/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.loottable;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.easyvillagers.corelib.codec.ValueInputOutputUtils;
import de.maxhenkel.easyvillagers.loottable.ModLootTables;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyBlockEntityData
extends LootItemConditionalFunction {
    public static final MapCodec<CopyBlockEntityData> CODEC = RecordCodecBuilder.mapCodec(instance -> CopyBlockEntityData.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CopyBlockEntityData::new));

    protected CopyBlockEntityData(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        BlockEntity blockEntity = (BlockEntity)context.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity == null) {
            return stack;
        }
        TagValueOutput valueOutput = ValueInputOutputUtils.createValueOutput(blockEntity, (HolderLookup.Provider)context.getLevel().registryAccess());
        blockEntity.saveWithFullMetadata((ValueOutput)valueOutput);
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)blockEntity.getType(), (TagValueOutput)valueOutput);
        stack.applyComponents(blockEntity.collectComponents());
        return stack;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)ModLootTables.COPY_BLOCK_ENTITY.get();
    }
}

