/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.MultiItemStackHandler;
import de.maxhenkel.easyvillagers.blocks.ConverterBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.datacomponents.VillagerData;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.VillagerConvertSlot;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class ConverterTileentity
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected NonNullList<ItemStack> inputInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected NonNullList<ItemStack> outputInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected long timer;
    protected UUID owner;
    protected MultiItemStackHandler itemHandler = new MultiItemStackHandler(this.inputInventory, this.outputInventory, VillagerConvertSlot::isValid);

    public ConverterTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.CONVERTER.get(), ((ConverterBlock)((Object)ModBlocks.CONVERTER.get())).defaultBlockState(), pos, state);
    }

    @Override
    public void tickServer() {
        if (this.timer <= 0L && !this.hasVillager()) {
            for (ItemStack stack : this.inputInventory) {
                if (!(stack.getItem() instanceof VillagerItem) || !this.consumeConvertItems()) continue;
                ItemStack copy = stack.copy();
                copy.setCount(1);
                this.setVillager(copy);
                stack.shrink(1);
                this.sync();
                break;
            }
        }
        if (this.hasVillager()) {
            Player ownerPlayer;
            if (this.advanceAge()) {
                this.sync();
            }
            if (this.timer == (long)ConverterTileentity.getZombifyTime()) {
                VillagerBlockBase.playVillagerSound(this.level, this.worldPosition, SoundEvents.ZOMBIE_INFECT);
                this.sync();
            } else if (this.timer == (long)ConverterTileentity.getCureTime()) {
                VillagerBlockBase.playVillagerSound(this.level, this.worldPosition, SoundEvents.ZOMBIE_VILLAGER_CURE);
                this.sync();
            } else if (this.timer == (long)ConverterTileentity.getConvertTime()) {
                VillagerBlockBase.playVillagerSound(this.level, this.worldPosition, SoundEvents.ZOMBIE_VILLAGER_CONVERTED);
                this.sync();
            } else if (this.timer >= (long)ConverterTileentity.getFinalizeTime() && (ownerPlayer = this.getOwnerPlayer()) != null) {
                for (int i = 0; i < this.outputInventory.size(); ++i) {
                    ItemStack stack = (ItemStack)this.outputInventory.get(i);
                    if (!stack.isEmpty()) continue;
                    EasyVillagerEntity villagerEntity = this.getVillagerEntity();
                    villagerEntity.onReputationEventFrom(ReputationEventType.ZOMBIE_VILLAGER_CURED, (Entity)ownerPlayer);
                    this.outputInventory.set(i, (Object)this.removeVillager().copy());
                    this.timer = 0L;
                    this.sync();
                    break;
                }
            }
            ++this.timer;
            this.setChanged();
            if (this.timer < (long)ConverterTileentity.getZombifyTime() || this.timer >= (long)ConverterTileentity.getConvertTime()) {
                VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
            } else {
                VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.ZOMBIE_VILLAGER_AMBIENT);
            }
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.ZOMBIE_AMBIENT);
        } else if (this.timer != 0L) {
            this.timer = 0L;
            this.setChanged();
        }
    }

    private boolean consumeConvertItems() {
        ItemStack appleStack = null;
        ItemStack potionStack = null;
        for (ItemStack stack : this.inputInventory) {
            if (appleStack == null && !stack.isEmpty() && stack.getItem() == Items.GOLDEN_APPLE) {
                appleStack = stack;
            }
            if (potionStack != null || stack.isEmpty() || !ConverterTileentity.isWeakness(stack)) continue;
            potionStack = stack;
        }
        if (appleStack != null && potionStack != null) {
            appleStack.shrink(1);
            potionStack.shrink(1);
            return true;
        }
        return false;
    }

    public static boolean isWeakness(ItemStack stack) {
        PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potionContents == null) {
            return false;
        }
        return potionContents.potion().filter(potionHolder -> potionHolder.equals((Object)Potions.WEAKNESS) || potionHolder.equals((Object)Potions.LONG_WEAKNESS)).isPresent();
    }

    public long getTimer() {
        return this.timer;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Player getOwnerPlayer() {
        if (this.owner == null) {
            return null;
        }
        if (this.level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)this.level;
            return serverWorld.getServer().getPlayerList().getPlayer(this.owner);
        }
        return this.level.getPlayerByUUID(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("InputInventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.inputInventory, (boolean)true, (HolderLookup.Provider)provider));
        compound.put("OutputInventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.outputInventory, (boolean)true, (HolderLookup.Provider)provider));
        compound.putLong("Timer", this.timer);
        if (this.owner != null) {
            compound.store("Owner", UUIDUtil.CODEC, (Object)this.owner);
        }
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        compound.getCompound("InputInventory").ifPresent(t -> VillagerData.convertInventory(t, this.inputInventory, provider));
        compound.getCompound("OutputInventory").ifPresent(t -> VillagerData.convertInventory(t, this.outputInventory, provider));
        this.timer = compound.getLongOr("Timer", 0L);
        this.owner = compound.read("Owner", UUIDUtil.CODEC).orElse(null);
        super.loadAdditional(compound, provider);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((ConverterTileentity)this).setChanged());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((ConverterTileentity)this).setChanged());
    }

    public static int getZombifyTime() {
        return 60;
    }

    public static int getCureTime() {
        return ConverterTileentity.getZombifyTime() + 60;
    }

    public static int getConvertTime() {
        return ConverterTileentity.getCureTime() + (Integer)Main.SERVER_CONFIG.convertingTime.get();
    }

    public static int getFinalizeTime() {
        return ConverterTileentity.getConvertTime() + 60;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

