/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easyvillagers.datacomponents.VillagerData;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class VillagerTileentity
extends FakeWorldTileentity {
    protected ItemStack villager = ItemStack.EMPTY;
    protected EasyVillagerEntity villagerEntity;

    public VillagerTileentity(BlockEntityType<?> type, BlockState defaultState, BlockPos pos, BlockState state) {
        super(type, defaultState, pos, state);
    }

    public ItemStack getVillager() {
        if (this.villagerEntity != null) {
            this.saveVillagerEntity();
        }
        return this.villager;
    }

    public boolean hasVillager() {
        return !this.villager.isEmpty();
    }

    @Nullable
    public EasyVillagerEntity getVillagerEntity() {
        if (this.villagerEntity == null && !this.villager.isEmpty()) {
            this.villagerEntity = VillagerData.createEasyVillager(this.villager, this.level);
        }
        return this.villagerEntity;
    }

    public void saveVillagerEntity() {
        if (this.villagerEntity != null) {
            VillagerData.applyToItem(this.villager, this.villagerEntity);
        }
    }

    public void setVillager(ItemStack villager) {
        this.villager = villager;
        this.removeTradingPlayer();
        if (villager.isEmpty()) {
            this.villagerEntity = null;
        } else {
            this.villagerEntity = VillagerData.createEasyVillager(villager, this.level);
            this.onAddVillager(this.villagerEntity);
        }
        this.setChanged();
        this.sync();
    }

    public void removeTradingPlayer() {
        if (this.villagerEntity != null) {
            this.villagerEntity.setTradingPlayer(null);
        }
    }

    protected void onAddVillager(EasyVillagerEntity villager) {
    }

    public ItemStack removeVillager() {
        ItemStack v = this.getVillager();
        this.setVillager(ItemStack.EMPTY);
        return v;
    }

    public boolean advanceAge() {
        return VillagerTileentity.advanceAge(this.getVillagerEntity());
    }

    public boolean advanceAge(int amount) {
        return VillagerTileentity.advanceAge(this.getVillagerEntity(), amount);
    }

    public static boolean advanceAge(EasyVillagerEntity villagerEntity, int amount) {
        if (villagerEntity == null) {
            return false;
        }
        int prevAge = villagerEntity.getAge();
        int age = prevAge + amount;
        villagerEntity.setAge(age);
        return prevAge < 0 && age >= 0;
    }

    public static boolean advanceAge(EasyVillagerEntity villagerEntity) {
        return VillagerTileentity.advanceAge(villagerEntity, 1);
    }

    public void setRemoved() {
        this.removeTradingPlayer();
        super.setRemoved();
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.hasVillager()) {
            compound.put("Villager", this.getVillager().save(provider));
        }
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        Optional<ItemStack> optionalItemStack = compound.getCompound("Villager").map(c -> VillagerData.convert(provider, c));
        if (optionalItemStack.isPresent()) {
            this.villager = optionalItemStack.get();
            this.villagerEntity = null;
        } else {
            this.removeVillager();
        }
        super.loadAdditional(compound, provider);
    }
}

