/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.ConverterTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.lang.ref.WeakReference;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.client.renderer.entity.state.ZombieVillagerRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class ConverterRenderer
extends VillagerRendererBase<ConverterTileentity> {
    private WeakReference<Zombie> zombieCache = new WeakReference<Object>(null);
    private WeakReference<ZombieRenderer> zombieRendererCache = new WeakReference<Object>(null);
    private WeakReference<ZombieVillagerRenderer> zombieVillagerRendererCache = new WeakReference<Object>(null);
    private WeakReference<ZombieVillager> zombieVillagerCache = new WeakReference<Object>(null);
    protected ZombieVillagerRenderState zombieVillagerRenderState;
    protected ZombieRenderState zombieRenderState;

    public ConverterRenderer(EntityModelSet entityModelSet) {
        super(entityModelSet);
    }

    @Override
    public void render(ConverterTileentity converter, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 vec) {
        EasyVillagerEntity villagerEntity;
        ZombieVillager zombieVillager;
        ZombieVillagerRenderer zombieVillagerRenderer;
        Zombie zombie;
        super.render(converter, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay, vec);
        matrixStack.pushPose();
        ZombieRenderer zombieRenderer = (ZombieRenderer)this.zombieRendererCache.get();
        if (zombieRenderer == null) {
            zombieRenderer = new ZombieRenderer(ConverterRenderer.createEntityRenderer());
            this.zombieRendererCache = new WeakReference<ZombieRenderer>(zombieRenderer);
        }
        if ((zombie = (Zombie)this.zombieCache.get()) == null) {
            zombie = new Zombie((Level)ConverterRenderer.minecraft.level);
            this.zombieCache = new WeakReference<Zombie>(zombie);
        }
        if ((zombieVillagerRenderer = (ZombieVillagerRenderer)this.zombieVillagerRendererCache.get()) == null) {
            zombieVillagerRenderer = new ZombieVillagerRenderer(ConverterRenderer.createEntityRenderer());
            this.zombieVillagerRendererCache = new WeakReference<ZombieVillagerRenderer>(zombieVillagerRenderer);
        }
        if ((zombieVillager = (ZombieVillager)this.zombieVillagerCache.get()) == null) {
            zombieVillager = new ZombieVillager(EntityType.ZOMBIE_VILLAGER, (Level)ConverterRenderer.minecraft.level);
            this.zombieVillagerCache = new WeakReference<ZombieVillager>(zombieVillager);
        }
        Direction direction = Direction.SOUTH;
        if (!converter.isFakeWorld()) {
            direction = (Direction)converter.getBlockState().getValue((Property)TraderBlock.FACING);
        }
        if ((villagerEntity = converter.getVillagerEntity()) != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(-0.3125, 0.0, 0.0);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            matrixStack.scale(0.4f, 0.4f, 0.4f);
            if (converter.getTimer() >= (long)ConverterTileentity.getZombifyTime() && converter.getTimer() < (long)ConverterTileentity.getConvertTime()) {
                zombieVillager.setVillagerData(villagerEntity.getVillagerData());
                zombieVillager.setBaby(villagerEntity.isBaby());
                zombieVillagerRenderer.render((LivingEntityRenderState)this.getZombieVillagerRenderState(zombieVillagerRenderer, zombieVillager), matrixStack, buffer, combinedLight);
            } else {
                VillagerRenderer villagerRenderer = this.getVillagerRenderer();
                villagerRenderer.render((LivingEntityRenderState)ConverterRenderer.getVillagerRenderState(villagerRenderer, villagerEntity), matrixStack, buffer, combinedLight);
            }
            matrixStack.popPose();
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.0625, 0.5);
        matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-direction.toYRot()));
        matrixStack.translate(0.3125, 0.0, 0.0);
        matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        matrixStack.scale(0.4f, 0.4f, 0.4f);
        zombieRenderer.render((LivingEntityRenderState)this.getZombieRenderState(zombieRenderer, zombie), matrixStack, buffer, combinedLight);
        matrixStack.popPose();
        matrixStack.popPose();
    }

    protected ZombieVillagerRenderState getZombieVillagerRenderState(ZombieVillagerRenderer renderer, ZombieVillager villager) {
        if (this.zombieVillagerRenderState == null) {
            this.zombieVillagerRenderState = renderer.createRenderState();
        }
        renderer.extractRenderState(villager, this.zombieVillagerRenderState, 0.0f);
        return this.zombieVillagerRenderState;
    }

    protected ZombieRenderState getZombieRenderState(ZombieRenderer renderer, Zombie zombie) {
        if (this.zombieRenderState == null) {
            this.zombieRenderState = renderer.createRenderState();
        }
        renderer.extractRenderState(zombie, this.zombieRenderState, 0.0f);
        return this.zombieRenderState;
    }
}

