/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.IncubatorTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class IncubatorRenderer
extends VillagerRendererBase<IncubatorTileentity> {
    public IncubatorRenderer(EntityModelSet entityModelSet) {
        super(entityModelSet);
    }

    @Override
    public void render(IncubatorTileentity incubator, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 vec) {
        super.render(incubator, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay, vec);
        matrixStack.pushPose();
        Direction direction = Direction.SOUTH;
        if (!incubator.isFakeWorld()) {
            direction = (Direction)incubator.getBlockState().getValue((Property)TraderBlock.FACING);
        }
        if (incubator.getVillagerEntity() != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.scale(0.45f, 0.45f, 0.45f);
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.render((LivingEntityRenderState)IncubatorRenderer.getVillagerRenderState(villagerRenderer, incubator.getVillagerEntity()), matrixStack, buffer, combinedLight);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }
}

