/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.IronFarmTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import java.lang.ref.WeakReference;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.state.IronGolemRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class IronFarmRenderer
extends VillagerRendererBase<IronFarmTileentity> {
    private WeakReference<Zombie> zombieCache = new WeakReference<Object>(null);
    private WeakReference<ZombieRenderer> zombieRendererCache = new WeakReference<Object>(null);
    private WeakReference<IronGolem> ironGolemCache = new WeakReference<Object>(null);
    private WeakReference<IronGolemRenderer> ironGolemRendererCache = new WeakReference<Object>(null);
    protected ZombieRenderState zombieRenderState;
    protected IronGolemRenderState ironGolemRenderState;

    public IronFarmRenderer(EntityModelSet entityModelSet) {
        super(entityModelSet);
    }

    @Override
    public void render(IronFarmTileentity farm, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 vec) {
        IronGolemRenderer ironGolemRenderer;
        IronGolem ironGolem;
        ZombieRenderer zombieRenderer;
        super.render(farm, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay, vec);
        matrixStack.pushPose();
        Zombie zombie = (Zombie)this.zombieCache.get();
        if (zombie == null) {
            zombie = new Zombie((Level)IronFarmRenderer.minecraft.level);
            this.zombieCache = new WeakReference<Zombie>(zombie);
        }
        if ((zombieRenderer = (ZombieRenderer)this.zombieRendererCache.get()) == null) {
            zombieRenderer = new ZombieRenderer(IronFarmRenderer.createEntityRenderer());
            this.zombieRendererCache = new WeakReference<ZombieRenderer>(zombieRenderer);
        }
        if ((ironGolem = (IronGolem)this.ironGolemCache.get()) == null) {
            ironGolem = new IronGolem(EntityType.IRON_GOLEM, (Level)IronFarmRenderer.minecraft.level);
            this.ironGolemCache = new WeakReference<IronGolem>(ironGolem);
        }
        if ((ironGolemRenderer = (IronGolemRenderer)this.ironGolemRendererCache.get()) == null) {
            ironGolemRenderer = new IronGolemRenderer(IronFarmRenderer.createEntityRenderer());
            this.ironGolemRendererCache = new WeakReference<IronGolemRenderer>(ironGolemRenderer);
        }
        Direction direction = Direction.SOUTH;
        if (!farm.isFakeWorld()) {
            direction = (Direction)farm.getBlockState().getValue((Property)TraderBlock.FACING);
        }
        if (farm.getVillagerEntity() != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(-0.3125, 0.0, -0.3125);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            matrixStack.scale(0.3f, 0.3f, 0.3f);
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.render((LivingEntityRenderState)IronFarmRenderer.getVillagerRenderState(villagerRenderer, farm.getVillagerEntity()), matrixStack, buffer, combinedLight);
            matrixStack.popPose();
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.0625, 0.5);
        matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-direction.toYRot()));
        matrixStack.translate(0.3125, 0.0, -0.3125);
        matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        matrixStack.scale(0.3f, 0.3f, 0.3f);
        zombieRenderer.render((LivingEntityRenderState)this.getZombieRenderState(zombieRenderer, zombie), matrixStack, buffer, combinedLight);
        matrixStack.popPose();
        if (farm.getTimer() >= (long)IronFarmTileentity.getGolemSpawnTime() && farm.getTimer() < (long)IronFarmTileentity.getGolemKillTime()) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(0.0, 0.0, 0.1875);
            matrixStack.scale(0.3f, 0.3f, 0.3f);
            ironGolem.hurtTime = farm.getTimer() % 20L < 10L ? 20 : 0;
            ironGolemRenderer.render((LivingEntityRenderState)this.getIronGolemRenderState(ironGolemRenderer, ironGolem), matrixStack, buffer, combinedLight);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    protected ZombieRenderState getZombieRenderState(ZombieRenderer renderer, Zombie zombie) {
        if (this.zombieRenderState == null) {
            this.zombieRenderState = renderer.createRenderState();
        }
        renderer.extractRenderState(zombie, this.zombieRenderState, 0.0f);
        return this.zombieRenderState;
    }

    protected IronGolemRenderState getIronGolemRenderState(IronGolemRenderer renderer, IronGolem golem) {
        if (this.ironGolemRenderState == null) {
            this.ironGolemRenderState = renderer.createRenderState();
        }
        renderer.extractRenderState(golem, this.ironGolemRenderState, 0.0f);
        return this.ironGolemRenderState;
    }
}

