/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.corelib.item;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemUtils {
    public static ItemStack itemStackAmount(int amount, ItemStack stack, Player player) {
        if (stack == null || stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (player != null && player.getAbilities().instabuild) {
            return stack;
        }
        stack.setCount(stack.getCount() + amount);
        if (stack.getCount() <= 0) {
            stack.setCount(0);
            return ItemStack.EMPTY;
        }
        if (stack.getCount() > stack.getMaxStackSize()) {
            stack.setCount(stack.getMaxStackSize());
        }
        return stack;
    }

    public static ItemStack decrItemStack(ItemStack stack, Player player) {
        return ItemUtils.itemStackAmount(-1, stack, player);
    }

    public static ItemStack incrItemStack(ItemStack stack, Player player) {
        return ItemUtils.itemStackAmount(1, stack, player);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.getItem() == stack2.getItem()) {
            return stack1.getDamageValue() == stack2.getDamageValue();
        }
        return false;
    }

    public static void saveInventory(HolderLookup.Provider provider, CompoundTag compound, String name, Container inv) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item.isEmpty()) continue;
            CompoundTag slot = new CompoundTag();
            slot.putInt("Slot", i);
            tagList.add((Object)item.save(provider, (Tag)slot));
        }
        compound.put(name, (Tag)tagList);
    }

    public static void saveInventory(HolderLookup.Provider provider, CompoundTag compound, String name, NonNullList<ItemStack> inv) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack item = (ItemStack)inv.get(i);
            if (item.isEmpty()) continue;
            CompoundTag slot = new CompoundTag();
            slot.putInt("Slot", i);
            tagList.add((Object)item.save(provider, (Tag)slot));
        }
        compound.put(name, (Tag)tagList);
    }

    public static void saveItemList(HolderLookup.Provider provider, CompoundTag compound, String name, NonNullList<ItemStack> list) {
        ListTag itemList = new ListTag();
        for (ItemStack stack : list) {
            if (stack.isEmpty()) continue;
            itemList.add((Object)stack.save(provider));
        }
        compound.put(name, (Tag)itemList);
    }

    public static void readInventory(HolderLookup.Provider provider, CompoundTag compound, String name, Container inv) {
        if (!compound.contains(name)) {
            return;
        }
        ListTag tagList = compound.getListOrEmpty(name);
        for (int i = 0; i < tagList.size(); ++i) {
            int j;
            Optional slotId;
            Optional slot = tagList.getCompound(i);
            if (slot.isEmpty() || (slotId = ((CompoundTag)slot.get()).getInt("Slot")).isEmpty() || (j = ((Integer)slotId.get()).intValue()) < 0 || j >= inv.getContainerSize()) continue;
            inv.setItem(j, ItemStack.parse((HolderLookup.Provider)provider, (Tag)((Tag)slot.get())).orElse(ItemStack.EMPTY));
        }
    }

    public static void readInventory(HolderLookup.Provider provider, CompoundTag compound, String name, NonNullList<ItemStack> inv) {
        if (!compound.contains(name)) {
            return;
        }
        ListTag tagList = compound.getListOrEmpty(name);
        for (int i = 0; i < tagList.size(); ++i) {
            int j;
            Optional slotId;
            Optional slot = tagList.getCompound(i);
            if (slot.isEmpty() || (slotId = ((CompoundTag)slot.get()).getInt("Slot")).isEmpty() || (j = ((Integer)slotId.get()).intValue()) < 0 || j >= inv.size()) continue;
            inv.set(j, (Object)ItemStack.parse((HolderLookup.Provider)provider, (Tag)((Tag)slot.get())).orElse(ItemStack.EMPTY));
        }
    }

    public static NonNullList<ItemStack> readItemList(HolderLookup.Provider provider, CompoundTag compound, String name, boolean includeEmpty) {
        NonNullList items = NonNullList.create();
        if (!compound.contains(name)) {
            return items;
        }
        ListTag itemList = compound.getListOrEmpty(name);
        for (int i = 0; i < itemList.size(); ++i) {
            Optional optionalItem = ItemStack.parse((HolderLookup.Provider)provider, (Tag)itemList.get(i));
            if (optionalItem.isEmpty()) continue;
            ItemStack item = (ItemStack)optionalItem.get();
            if (!includeEmpty) {
                if (item.isEmpty()) continue;
                items.add((Object)item);
                continue;
            }
            items.add((Object)item);
        }
        return items;
    }

    public static NonNullList<ItemStack> readItemList(HolderLookup.Provider provider, CompoundTag compound, String name) {
        return ItemUtils.readItemList(provider, compound, name, true);
    }

    public static void readItemList(HolderLookup.Provider provider, CompoundTag compound, String name, NonNullList<ItemStack> list) {
        if (!compound.contains(name)) {
            return;
        }
        ListTag itemList = compound.getListOrEmpty(name);
        for (int i = 0; i < itemList.size() && i < list.size(); ++i) {
            list.set(i, (Object)ItemStack.parse((HolderLookup.Provider)provider, (Tag)itemList.get(i)).orElse(ItemStack.EMPTY));
        }
    }

    public static void removeStackFromSlot(Container inventory, int index) {
        inventory.setItem(index, ItemStack.EMPTY);
    }

    public static boolean isStackable(ItemStack stack1, ItemStack stack2) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public static CompoundTag writeOverstackedItem(HolderLookup.Provider provider, CompoundTag compound, ItemStack stack) {
        stack.save(provider, (Tag)compound);
        compound.remove("Count");
        compound.putInt("Count", stack.getCount());
        return compound;
    }

    public static ItemStack readOverstackedItem(HolderLookup.Provider provider, CompoundTag compound) {
        CompoundTag data = compound.copy();
        int count = data.getIntOr("Count", 0);
        data.remove("Count");
        data.putByte("Count", (byte)1);
        ItemStack stack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)data).orElse(ItemStack.EMPTY);
        stack.setCount(count);
        return stack;
    }
}

