/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.events;

import de.maxhenkel.easyvillagers.ClientConfig;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.CycleTradesButton;
import de.maxhenkel.easyvillagers.net.MessageCycleTrades;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.inventory.MerchantMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuiEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onOpenScreen(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof MerchantScreen)) {
            return;
        }
        MerchantScreen merchantScreen = (MerchantScreen)screen;
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (!((Boolean)Main.SERVER_CONFIG.tradeCycling.get()).booleanValue()) {
            return;
        }
        ClientConfig.CycleTradesButtonLocation loc = (ClientConfig.CycleTradesButtonLocation)((Object)Main.CLIENT_CONFIG.cycleTradesButtonLocation.get());
        if (loc.equals((Object)ClientConfig.CycleTradesButtonLocation.NONE)) {
            return;
        }
        event.addListener((GuiEventListener)new CycleTradesButton(switch (loc) {
            default -> merchantScreen.getGuiLeft() + 107;
            case ClientConfig.CycleTradesButtonLocation.TOP_RIGHT -> merchantScreen.getGuiLeft() + 250;
        }, merchantScreen.getGuiTop() + 8, b -> PacketDistributor.sendToServer((CustomPacketPayload)new MessageCycleTrades(), (CustomPacketPayload[])new CustomPacketPayload[0]), merchantScreen));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (event.getKey() != Main.CYCLE_TRADES_KEY.getKey().getValue() || event.getAction() != 0) {
            return;
        }
        if (!Main.SERVER_CONFIG.getConfigSpec().isLoaded() || !((Boolean)Main.SERVER_CONFIG.tradeCycling.get()).booleanValue()) {
            return;
        }
        Screen currentScreen = mc.screen;
        if (!(currentScreen instanceof MerchantScreen)) {
            return;
        }
        MerchantScreen screen = (MerchantScreen)currentScreen;
        if (!CycleTradesButton.canCycle((MerchantMenu)screen.getMenu())) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new MessageCycleTrades(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public static void onCycleTrades(ServerPlayer player) {
        if (!((Boolean)Main.SERVER_CONFIG.tradeCycling.get()).booleanValue()) {
            return;
        }
        if (!(player.containerMenu instanceof MerchantMenu)) {
            return;
        }
        MerchantMenu container = (MerchantMenu)player.containerMenu;
        if (container.getTraderXp() > 0 && container.tradeContainer.getActiveOffer() != null) {
            return;
        }
        if (!(container.trader instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)container.trader;
        villager.offers = null;
        EasyVillagerEntity.recalculateOffers(villager);
        player.sendMerchantOffers(container.containerId, villager.getOffers(), villager.getVillagerData().level(), villager.getVillagerXp(), villager.showProgressBar(), villager.canRestock());
    }
}

