/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.gui;

import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.tileentity.InventoryViewerTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.Containers;
import de.maxhenkel.easyvillagers.gui.VillagerContainerBase;
import de.maxhenkel.easyvillagers.gui.VillagerInventorySlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class InventoryViewerContainer
extends VillagerContainerBase {
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = ResourceLocation.withDefaultNamespace((String)"container/slot/helmet");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = ResourceLocation.withDefaultNamespace((String)"container/slot/chestplate");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = ResourceLocation.withDefaultNamespace((String)"container/slot/leggings");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = ResourceLocation.withDefaultNamespace((String)"container/slot/boots");
    public static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{EMPTY_ARMOR_SLOT_BOOTS, EMPTY_ARMOR_SLOT_LEGGINGS, EMPTY_ARMOR_SLOT_CHESTPLATE, EMPTY_ARMOR_SLOT_HELMET};
    protected InventoryViewerTileentity inventoryViewer;
    protected EasyVillagerEntity villager;

    public InventoryViewerContainer(int id, Container playerInventory, InventoryViewerTileentity inventoryViewer, ContainerLevelAccess access) {
        super((MenuType)Containers.INVENTORY_VIEWER_CONTAINER.get(), id, playerInventory, null, access);
        int i;
        this.inventoryViewer = inventoryViewer;
        this.villager = inventoryViewer.getVillagerEntity();
        Container villagerInventory = inventoryViewer.getVillagerInventory();
        Container armorInventory = inventoryViewer.getVillagerArmorInventory();
        for (i = 0; i < villagerInventory.getContainerSize() && i < 4; ++i) {
            this.addSlot(new VillagerInventorySlot(villagerInventory, i, 52 + i * 18, 20, inventoryViewer));
        }
        for (i = 4; i < villagerInventory.getContainerSize() && i < 8; ++i) {
            this.addSlot(new VillagerInventorySlot(villagerInventory, i, 52 + (i - 4) * 18, 38, inventoryViewer));
        }
        for (i = 0; i < 4; ++i) {
            final EquipmentSlot equipmentslot = SLOT_IDS[i];
            this.addSlot(new Slot(armorInventory, 3 - i, 52 + i * 18, 69){

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(ItemStack stack) {
                    return InventoryViewerContainer.this.villager.getEquipmentSlotForItem(stack) == equipmentslot;
                }

                public boolean mayPickup(Player player) {
                    ItemStack itemstack = this.getItem();
                    return !itemstack.isEmpty() && !player.isCreative() && EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) ? false : super.mayPickup(player);
                }

                public ResourceLocation getNoItemIcon() {
                    return TEXTURE_EMPTY_SLOTS[equipmentslot.getIndex()];
                }
            });
        }
        this.addPlayerInventorySlots();
    }

    public InventoryViewerContainer(int id, Inventory playerInventory, BlockPos pos) {
        this(id, playerInventory, InventoryViewerContainer.get(pos));
    }

    public InventoryViewerContainer(int id, Inventory playerInventory, InventoryViewerTileentity te) {
        this(id, (Container)playerInventory, te, ContainerLevelAccess.create((Level)te.getLevel(), (BlockPos)te.getBlockPos()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static InventoryViewerTileentity get(BlockPos pos) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            throw new IllegalStateException("No client level present");
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof InventoryViewerTileentity)) {
            throw new IllegalStateException("Could not find block entity");
        }
        InventoryViewerTileentity iv = (InventoryViewerTileentity)blockEntity;
        return iv;
    }

    @Override
    public Block getBlock() {
        return (Block)ModBlocks.INVENTORY_VIEWER.get();
    }

    @Override
    public int getInvOffset() {
        return 16;
    }

    @Override
    public int getInventorySize() {
        return 12;
    }

    @Override
    public boolean stillValid(Player player) {
        return super.stillValid(player) && this.villager == this.inventoryViewer.getVillagerEntity();
    }
}

