/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.items.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.BlockRendererBase;
import de.maxhenkel.easyvillagers.datacomponents.VillagerData;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.VillagerRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class VillagerSpecialRenderer
implements SpecialModelRenderer<VillagerRenderState> {
    protected static final Minecraft minecraft = Minecraft.getInstance();
    private VillagerRenderer renderer;
    private VillagerRenderState renderState;

    public VillagerSpecialRenderer(EntityModelSet modelSet) {
    }

    public void render(@Nullable VillagerRenderState villagerRenderState, ItemDisplayContext itemDisplayContext, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean b) {
        if (villagerRenderState == null) {
            return;
        }
        this.getRenderer().render((LivingEntityRenderState)villagerRenderState, stack, bufferSource, light);
    }

    @Nullable
    public VillagerRenderState extractArgument(ItemStack stack) {
        EasyVillagerEntity cacheVillager = VillagerData.getCacheVillager(stack, (Level)VillagerSpecialRenderer.minecraft.level);
        if (this.renderState == null) {
            this.renderState = this.getRenderer().createRenderState();
        }
        this.renderer.extractRenderState((Villager)cacheVillager, this.renderState, 0.0f);
        return this.renderState;
    }

    private VillagerRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new VillagerRenderer(BlockRendererBase.createEntityRenderer());
        }
        return this.renderer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Unbaked
    implements SpecialModelRenderer.Unbaked {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return new VillagerSpecialRenderer(modelSet);
        }
    }
}

