/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.MultiItemStackHandler;
import de.maxhenkel.easyvillagers.blocks.AutoTraderBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.datacomponents.VillagerData;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class AutoTraderTileentity
extends TraderTileentityBase
implements ITickableBlockEntity {
    protected Container tradeGuiInv = new SimpleContainer(3);
    protected final NonNullList<ItemStack> inputInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected final NonNullList<ItemStack> outputInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected int tradeIndex;
    protected ItemStackHandler outputHandler = new ItemStackHandler(this.outputInventory);
    protected MultiItemStackHandler itemHandler = new MultiItemStackHandler(this.inputInventory, this.outputInventory);

    public AutoTraderTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.AUTO_TRADER.get(), ((AutoTraderBlock)((Object)ModBlocks.AUTO_TRADER.get())).defaultBlockState(), pos, state);
    }

    @Override
    public void tick() {
        if (!this.hasVillager()) {
            return;
        }
        if (this.level.getGameTime() % (long)((Integer)Main.SERVER_CONFIG.autoTraderCooldown.get()).intValue() != 0L) {
            return;
        }
        MerchantOffer offer = this.getOffer();
        if (offer == null || offer.isOutOfStock() || this.inputInventory.isEmpty()) {
            return;
        }
        EasyVillagerEntity villager = this.getVillagerEntity();
        ItemStack autoTradeInputA = this.getAutoTradeInputA();
        ItemStack costB = offer.getCostB();
        ItemStack result = offer.getResult();
        if (!(this.hasEnoughItems(autoTradeInputA, false) && this.hasEnoughItems(costB, false) && this.canFitItems(result, false))) {
            return;
        }
        this.hasEnoughItems(autoTradeInputA, true);
        this.hasEnoughItems(costB, true);
        this.canFitItems(result, true);
        offer.increaseUses();
        villager.setVillagerXp(villager.getVillagerXp() + offer.getXp());
        if (villager.shouldIncreaseLevel()) {
            villager.increaseProfessionLevelOnUpdate = true;
        }
        this.setChanged();
    }

    protected boolean hasEnoughItems(ItemStack buying, boolean remove) {
        if (buying.isEmpty()) {
            return true;
        }
        int amount = buying.getCount();
        for (ItemStack stack : this.inputInventory) {
            if (!ItemUtils.isStackable(stack, buying)) continue;
            int am = Math.min(amount, stack.getCount());
            if (remove) {
                stack.shrink(am);
            }
            if ((amount -= am) > 0) continue;
            return true;
        }
        return false;
    }

    protected boolean canFitItems(ItemStack insert, boolean doInsert) {
        if (insert.isEmpty()) {
            return true;
        }
        ItemStack stack = insert.copy();
        for (int i = 0; i < this.outputHandler.getSlots() && !(stack = this.outputHandler.insertItem(i, stack, !doInsert)).isEmpty(); ++i) {
        }
        return stack.isEmpty();
    }

    public Container getTradeGuiInv() {
        this.updateTradeInv();
        return this.tradeGuiInv;
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
        this.updateTradeInv();
        this.setChanged();
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        this.updateTradeInv();
    }

    @Override
    public void setWorkstation(Block workstation) {
        super.setWorkstation(workstation);
        this.updateTradeInv();
    }

    public void nextTrade() {
        int tradeCount = this.getTradeCount();
        if (tradeCount > 0) {
            this.setTradeIndex(Math.floorMod(this.tradeIndex + 1, tradeCount));
        }
    }

    public void prevTrade() {
        int tradeCount = this.getTradeCount();
        if (tradeCount > 0) {
            this.setTradeIndex(Math.floorMod(this.tradeIndex - 1, tradeCount));
        }
    }

    protected void updateTradeInv() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            this.tradeGuiInv.clearContent();
            return;
        }
        villagerEntity.recalculateOffers();
        MerchantOffer offer = this.getOffer();
        if (offer == null) {
            this.tradeGuiInv.clearContent();
            return;
        }
        this.tradeGuiInv.setItem(0, this.getAutoTradeInputA());
        this.tradeGuiInv.setItem(1, offer.getCostB());
        this.tradeGuiInv.setItem(2, offer.getResult());
    }

    public ItemStack getAutoTradeInputA() {
        MerchantOffer offer = this.getOffer();
        if (offer == null) {
            return ItemStack.EMPTY.copy();
        }
        ItemStack costA = offer.getCostA().copy();
        int amount = Math.min(costA.getCount(), offer.getBaseCostA().getCount());
        costA.setCount(amount);
        return costA;
    }

    @Nullable
    public MerchantOffer getOffer() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return null;
        }
        if (villagerEntity.level().isClientSide()) {
            return null;
        }
        MerchantOffers offers = villagerEntity.getOffers();
        if (this.tradeIndex < 0 || this.tradeIndex >= offers.size()) {
            return null;
        }
        return (MerchantOffer)offers.get(this.tradeIndex);
    }

    protected int getTradeCount() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return 0;
        }
        return villagerEntity.getOffers().size();
    }

    @Override
    protected long calculateNextRestock() {
        return (Integer)Main.SERVER_CONFIG.autoTraderMinRestockTime.get() + this.level.random.nextInt(Math.max((Integer)Main.SERVER_CONFIG.autoTraderMaxRestockTime.get() - (Integer)Main.SERVER_CONFIG.autoTraderMinRestockTime.get(), 1));
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("Trade", this.tradeIndex);
        compound.put("InputInventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.inputInventory, (boolean)true, (HolderLookup.Provider)provider));
        compound.put("OutputInventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.outputInventory, (boolean)true, (HolderLookup.Provider)provider));
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.tradeIndex = compound.getInt("Trade");
        VillagerData.convertInventory(compound.getCompound("InputInventory"), this.inputInventory, provider);
        VillagerData.convertInventory(compound.getCompound("OutputInventory"), this.outputInventory, provider);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((AutoTraderTileentity)this).setChanged());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((AutoTraderTileentity)this).setChanged());
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

