/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.MultiItemStackHandler;
import de.maxhenkel.easyvillagers.blocks.IncubatorBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.datacomponents.VillagerData;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.VillagerIncubateSlot;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class IncubatorTileentity
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected NonNullList<ItemStack> inputInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected NonNullList<ItemStack> outputInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected MultiItemStackHandler itemHandler = new MultiItemStackHandler(this.inputInventory, this.outputInventory, VillagerIncubateSlot::isValid);

    public IncubatorTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.INCUBATOR.get(), ((IncubatorBlock)((Object)ModBlocks.INCUBATOR.get())).defaultBlockState(), pos, state);
    }

    @Override
    public void tickServer() {
        if (!this.hasVillager()) {
            for (ItemStack stack : this.inputInventory) {
                if (!(stack.getItem() instanceof VillagerItem)) continue;
                ItemStack copy = stack.copy();
                copy.setCount(1);
                this.setVillager(copy);
                stack.shrink(1);
                this.sync();
                break;
            }
        }
        if (this.hasVillager()) {
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
            EasyVillagerEntity villagerEntity = this.getVillagerEntity();
            if (villagerEntity.isBaby()) {
                if (this.advanceAge(Math.min((Integer)Main.SERVER_CONFIG.incubatorSpeed.get(), Math.abs(villagerEntity.getAge())))) {
                    this.sync();
                }
            } else {
                this.advanceAge(1);
            }
            if (villagerEntity.getAge() > 20) {
                for (int i = 0; i < this.outputInventory.size(); ++i) {
                    ItemStack stack = (ItemStack)this.outputInventory.get(i);
                    if (!stack.isEmpty()) continue;
                    this.outputInventory.set(i, (Object)this.removeVillager().copy());
                    this.sync();
                    break;
                }
            }
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("InputInventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.inputInventory, (boolean)true, (HolderLookup.Provider)provider));
        compound.put("OutputInventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.outputInventory, (boolean)true, (HolderLookup.Provider)provider));
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        VillagerData.convertInventory(compound.getCompound("InputInventory"), this.inputInventory, provider);
        VillagerData.convertInventory(compound.getCompound("OutputInventory"), this.outputInventory, provider);
        super.loadAdditional(compound, provider);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((IncubatorTileentity)this).setChanged());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((IncubatorTileentity)this).setChanged());
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

