/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.blocks.InventoryViewerBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.VillagerItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class InventoryViewerTileentity
extends VillagerTileentity
implements IServerTickableBlockEntity {
    public InventoryViewerTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.INVENTORY_VIEWER.get(), ((InventoryViewerBlock)((Object)ModBlocks.INVENTORY_VIEWER.get())).defaultBlockState(), pos, state);
    }

    @Override
    public void tickServer() {
        if (this.hasVillager()) {
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
        }
    }

    public Container getVillagerInventory() {
        return new ItemListInventory((NonNullList<ItemStack>)this.getVillagerEntity().getInventory().getItems(), this::setChanged);
    }

    public Container getVillagerArmorInventory() {
        return new ItemListInventory((NonNullList<ItemStack>)((NonNullList)this.getVillagerEntity().getArmorSlots()), this::setChanged);
    }

    public IItemHandler getItemHandler() {
        EasyVillagerEntity ve = this.getVillagerEntity();
        if (ve == null) {
            return null;
        }
        return new VillagerItemStackHandler((NonNullList<ItemStack>)ve.getInventory().getItems(), this);
    }

    public void setChanged() {
        super.setChanged();
        this.saveVillagerEntity();
        if (this.level != null) {
            this.level.invalidateCapabilities(this.worldPosition);
        }
    }
}

