/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TraderTileentityBase
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected Block workstation = Blocks.AIR;
    protected long nextRestock;

    public TraderTileentityBase(BlockEntityType<?> type, BlockState defaultState, BlockPos pos, BlockState state) {
        super(type, defaultState, pos, state);
    }

    public Block getWorkstation() {
        return this.workstation;
    }

    public boolean hasWorkstation() {
        return this.workstation != Blocks.AIR;
    }

    public void setWorkstation(Block workstation) {
        this.workstation = workstation;
        if (this.hasVillager()) {
            this.fixProfession();
        }
        this.setChanged();
        this.sync();
    }

    public Block removeWorkstation() {
        Block w = this.workstation;
        this.setWorkstation(Blocks.AIR);
        return w;
    }

    public boolean isValidBlock(Block block) {
        return PoiTypes.forState((BlockState)block.defaultBlockState()).isPresent();
    }

    public VillagerProfession getWorkstationProfession() {
        return PoiTypes.forState((BlockState)this.workstation.defaultBlockState()).flatMap(pointOfInterestType -> BuiltInRegistries.VILLAGER_PROFESSION.stream().filter(villagerProfession -> villagerProfession.heldJobSite().test(pointOfInterestType)).findFirst()).orElse(VillagerProfession.NONE);
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        if (this.hasWorkstation()) {
            this.fixProfession();
        }
    }

    private void fixProfession() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v == null || v.getVillagerXp() > 0 || v.getVillagerData().getProfession().equals((Object)VillagerProfession.NITWIT)) {
            return;
        }
        v.setVillagerData(v.getVillagerData().setProfession(this.getWorkstationProfession()));
    }

    public boolean openTradingGUI(Player playerEntity) {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return false;
        }
        if (villagerEntity.isBaby()) {
            return false;
        }
        VillagerProfession profession = villagerEntity.getVillagerData().getProfession();
        if (profession.equals((Object)VillagerProfession.NONE) || profession.equals((Object)VillagerProfession.NITWIT)) {
            return false;
        }
        if (villagerEntity.isTrading()) {
            return false;
        }
        if (this.level == null || this.level.isClientSide()) {
            return true;
        }
        villagerEntity.setPos((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.0, (double)this.getBlockPos().getZ() + 0.5);
        villagerEntity.startTrading(playerEntity);
        return true;
    }

    @Override
    public void tickServer() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v == null) {
            return;
        }
        if (this.advanceAge()) {
            this.sync();
        }
        this.setChanged();
        VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
        if (!v.isTrading()) {
            if (v.increaseProfessionLevelOnUpdate) {
                v.increaseMerchantCareer();
                v.increaseProfessionLevelOnUpdate = false;
                this.sync();
            }
            if (this.level.getGameTime() - this.getLastRestock() > this.nextRestock && v.getVillagerData().getProfession().equals((Object)this.getWorkstationProfession())) {
                this.restock();
                this.nextRestock = this.calculateNextRestock();
            }
        }
    }

    protected long calculateNextRestock() {
        return (Integer)Main.SERVER_CONFIG.traderMinRestockTime.get() + this.level.random.nextInt(Math.max((Integer)Main.SERVER_CONFIG.traderMaxRestockTime.get() - (Integer)Main.SERVER_CONFIG.traderMinRestockTime.get(), 1));
    }

    protected void restock() {
        try {
            EasyVillagerEntity villagerEntity = this.getVillagerEntity();
            if (villagerEntity == null) {
                return;
            }
            villagerEntity.restock();
            SoundEvent workSound = villagerEntity.getVillagerData().getProfession().workSound();
            if (workSound != null) {
                VillagerBlockBase.playVillagerSound(this.level, this.getBlockPos(), workSound);
            }
        }
        catch (Exception e) {
            Main.LOGGER.error("Error restocking villager", (Throwable)e);
        }
    }

    protected long getLastRestock() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return 0L;
        }
        return villagerEntity.lastRestockGameTime;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.hasWorkstation()) {
            compound.putString("Workstation", BuiltInRegistries.BLOCK.getKey((Object)this.workstation).toString());
        }
        compound.putLong("NextRestock", this.nextRestock);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("Workstation")) {
            this.workstation = BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)compound.getString("Workstation"))).map(Holder.Reference::value).orElse(Blocks.AIR);
        } else {
            this.removeWorkstation();
        }
        this.nextRestock = compound.getLong("NextRestock");
        super.loadAdditional(compound, provider);
    }
}

