/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import de.maxhenkel.easyvillagers.corelib.CachedMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class TraderRenderer
extends VillagerRendererBase<TraderTileentity> {
    private static final Minecraft mc = Minecraft.getInstance();
    private static final CachedMap<Block, BlockState> blockStateCache = new CachedMap(10000L);
    public static final Map<ResourceLocation, Consumer<PoseStack>> TRANSFORMS = new HashMap<ResourceLocation, Consumer<PoseStack>>();
    private static final Map<Block, Consumer<PoseStack>> TRANSFORMS_CACHE = new HashMap<Block, Consumer<PoseStack>>();
    public static final Map<ResourceLocation, ResourceLocation> TOP_BLOCKS = new HashMap<ResourceLocation, ResourceLocation>();
    private static final Map<Block, BlockState> TOP_BLOCK_CACHE = new HashMap<Block, BlockState>();

    public TraderRenderer(EntityModelSet entityModelSet) {
        super(entityModelSet);
    }

    @Override
    public void render(TraderTileentity trader, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.render(trader, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        TraderRenderer.renderTraderBase(this.getVillagerRenderer(), trader, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
    }

    public static void renderTraderBase(VillagerRenderer renderer, TraderTileentityBase trader, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        matrixStack.pushPose();
        Direction direction = Direction.SOUTH;
        if (!trader.isFakeWorld()) {
            direction = (Direction)trader.getBlockState().getValue((Property)TraderBlock.FACING);
        }
        if (trader.getVillagerEntity() != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(0.0, 0.0, -0.25);
            matrixStack.scale(0.45f, 0.45f, 0.45f);
            renderer.render((LivingEntityRenderState)TraderRenderer.getVillagerRenderState(renderer, trader.getVillagerEntity()), matrixStack, buffer, combinedLight);
            matrixStack.popPose();
        }
        if (trader.hasWorkstation()) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(0.0, 0.0, 0.125);
            matrixStack.translate(-0.5, 0.0, -0.5);
            matrixStack.scale(0.45f, 0.45f, 0.45f);
            matrixStack.translate(0.6111111111111112, 0.0, 0.6111111111111112);
            BlockState workstation = TraderRenderer.getState(trader.getWorkstation());
            TraderRenderer.getTransforms(workstation).accept(matrixStack);
            TraderRenderer.renderBlock(workstation, matrixStack, buffer, combinedLight, combinedOverlay);
            BlockState topBlock = TraderRenderer.getTopBlock(workstation);
            if (!topBlock.isAir()) {
                matrixStack.translate(0.0, 1.0, 0.0);
                TraderRenderer.renderBlock(topBlock, matrixStack, buffer, combinedLight, combinedOverlay);
            }
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    public static void renderBlock(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        mc.getBlockRenderer().renderSingleBlock(state, matrixStack, buffer, combinedLight, combinedOverlay);
    }

    public static BlockState getState(Block block) {
        return blockStateCache.get(block, () -> TraderRenderer.getFittingState(block));
    }

    protected static BlockState getFittingState(Block block) {
        if (block == Blocks.GRINDSTONE) {
            return (BlockState)block.defaultBlockState().setValue((Property)GrindstoneBlock.FACE, (Comparable)AttachFace.FLOOR);
        }
        return block.defaultBlockState();
    }

    protected static Consumer<PoseStack> getTransforms(BlockState block) {
        Consumer<PoseStack> cached = TRANSFORMS_CACHE.get(block.getBlock());
        if (cached != null) {
            return cached;
        }
        Consumer<PoseStack> transform = TRANSFORMS.get(BuiltInRegistries.BLOCK.getKey((Object)block.getBlock()));
        if (transform == null) {
            transform = stack -> {};
        }
        TRANSFORMS_CACHE.put(block.getBlock(), transform);
        return transform;
    }

    protected static BlockState getTopBlock(BlockState bottom) {
        BlockState cached = TOP_BLOCK_CACHE.get(bottom.getBlock());
        if (cached != null) {
            return cached;
        }
        ResourceLocation resourceLocation = TOP_BLOCKS.get(BuiltInRegistries.BLOCK.getKey((Object)bottom.getBlock()));
        if (resourceLocation == null) {
            BlockState state = Blocks.AIR.defaultBlockState();
            TOP_BLOCK_CACHE.put(bottom.getBlock(), state);
            return state;
        }
        if (!BuiltInRegistries.BLOCK.containsKey(resourceLocation)) {
            BlockState state = Blocks.AIR.defaultBlockState();
            TOP_BLOCK_CACHE.put(bottom.getBlock(), state);
            return state;
        }
        Block b = BuiltInRegistries.BLOCK.get(resourceLocation).map(Holder.Reference::value).orElse(Blocks.AIR);
        BlockState state = b.defaultBlockState();
        TOP_BLOCK_CACHE.put(bottom.getBlock(), state);
        return state;
    }

    static {
        Consumer<PoseStack> immersiveEngineering = stack -> stack.translate(-0.5, 0.0, 0.0);
        TRANSFORMS.put(ResourceLocation.fromNamespaceAndPath((String)"immersiveengineering", (String)"workbench"), immersiveEngineering);
        TRANSFORMS.put(ResourceLocation.fromNamespaceAndPath((String)"immersiveengineering", (String)"circuit_table"), immersiveEngineering);
        TOP_BLOCKS.put(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"gas_station"), ResourceLocation.fromNamespaceAndPath((String)"car", (String)"gas_station_top"));
    }
}

