/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.search;

import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import red.jackf.jackfredlib.api.base.ResultHolder;
import red.jackf.whereisit.WhereIsIt;
import red.jackf.whereisit.api.SearchRequest;
import red.jackf.whereisit.api.SearchResult;
import red.jackf.whereisit.api.search.BlockSearcher;
import red.jackf.whereisit.api.search.ConnectedBlocksGrabber;
import red.jackf.whereisit.config.WhereIsItConfig;
import red.jackf.whereisit.networking.ClientboundResultsPacket;
import red.jackf.whereisit.networking.ServerboundSearchForItemPacket;
import red.jackf.whereisit.serverside.ServerSideRenderer;
import red.jackf.whereisit.util.RateLimiter;

public class SearchHandler {
    public static void handleFromPacket(ServerboundSearchForItemPacket packet, class_3222 player, PacketSender ignored) {
        SearchHandler.handle(packet.id(), packet.request(), player);
    }

    public static void handle(long requestId, SearchRequest request, class_3222 player) {
        ServerSideRenderer.fadeServerSide(player);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER && ((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getServer().rateLimit) {
            long time = player.method_51469().method_8510();
            if (RateLimiter.rateLimited(player, time)) {
                player.method_64398((class_2561)class_2561.method_43470((String)"[WhereIsIt] Slow down!").method_27692(class_124.field_1061));
                return;
            }
            RateLimiter.add(player, time);
        }
        if (!request.hasCriteria()) {
            WhereIsIt.LOGGER.warn("Empty request from {}", (Object)player.method_7334().name());
            return;
        }
        WhereIsIt.LOGGER.debug("Server search for {}: {}", (Object)player.method_5820(), (Object)request);
        long startTime = System.nanoTime();
        class_2338 startPos = player.method_24515();
        class_3218 level = player.method_51469();
        class_2338.class_2339 pos = new class_2338.class_2339();
        HashMap<class_2338, SearchResult> results = new HashMap<class_2338, SearchResult>();
        int range = ((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getCommon().searchRangeBlocks;
        int maxRange = range * range;
        for (int x = startPos.method_10263() - range; x <= startPos.method_10263() + range; ++x) {
            pos.method_33097(x);
            for (int y = startPos.method_10264() - range; y <= startPos.method_10264() + range; ++y) {
                pos.method_33098(y);
                for (int z = startPos.method_10260() - range; z <= startPos.method_10260() + range; ++z) {
                    ResultHolder<SearchResult> result;
                    class_2680 state;
                    List<class_2338> connected;
                    class_2338 adjustedRoot;
                    pos.method_33099(z);
                    if (pos.method_10262((class_2382)startPos) > (double)maxRange || results.containsKey(adjustedRoot = (connected = ConnectedBlocksGrabber.getConnected((class_1937)level, state = level.method_8320((class_2338)pos), (class_2338)pos)).get(0)) || !(result = ((BlockSearcher)BlockSearcher.EVENT.invoker()).searchPosition(request, player, level, state, adjustedRoot)).hasValue()) continue;
                    results.put(adjustedRoot, ((SearchResult)result.get()).withOtherPositions(connected));
                }
            }
        }
        WhereIsIt.LOGGER.debug("Server search results for {}: {}", (Object)player.method_5820(), results);
        long time = System.nanoTime() - startTime;
        String timingStr = "Search time: %.2fms (%dns)".formatted(Float.valueOf((float)time / 1000000.0f), time);
        WhereIsIt.LOGGER.debug(timingStr);
        if (((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getCommon().debug.printSearchTime) {
            player.method_64398((class_2561)class_2561.method_43470((String)("[Where Is It] " + timingStr)).method_27692(class_124.field_1054));
        }
        if (!results.isEmpty()) {
            if (((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getCommon().debug.forceServerSideHighlightsOnly || !ServerPlayNetworking.canSend((class_3222)player, ClientboundResultsPacket.TYPE)) {
                ServerSideRenderer.doServersideRendering(player, results.values());
            } else {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientboundResultsPacket(requestId, results.values(), request));
            }
        }
    }
}

