/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.serverside;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8113;
import org.joml.Vector3f;
import red.jackf.jackfredlib.api.colour.Colour;
import red.jackf.jackfredlib.api.lying.Debris;
import red.jackf.jackfredlib.api.lying.Lie;
import red.jackf.jackfredlib.api.lying.entity.EntityLie;
import red.jackf.jackfredlib.api.lying.entity.builders.EntityBuilders;
import red.jackf.jackfredlib.api.lying.entity.builders.display.BlockDisplayBuilder;
import red.jackf.whereisit.WhereIsIt;
import red.jackf.whereisit.api.SearchResult;
import red.jackf.whereisit.config.WhereIsItConfig;

public class ServerSideRenderer {
    private static final class_2248 MAIN_BLOCK = class_2246.field_10465;
    private static final class_2248 ALT_BLOCK = class_2246.field_16540;
    private static final float HIGHLIGHT = 0.7f;
    private static final Multimap<GameProfile, EntityLie<class_8113.class_8115>> playerHighlightLies = MultimapBuilder.hashKeys().arrayListValues().build();

    public static void fadeServerSide(class_3222 player) {
        playerHighlightLies.removeAll((Object)player.method_7334()).forEach(Lie::fade);
    }

    private static class_8113.class_8115 makeAlternateBlockDisplay(class_3218 level, class_2338 pos, Colour colour) {
        return (class_8113.class_8115)((BlockDisplayBuilder)((BlockDisplayBuilder)EntityBuilders.blockDisplay((class_3218)level).positionCentered(pos)).state(ALT_BLOCK.method_9564()).scaleAndCenter(0.7f).glowing(true, colour)).build();
    }

    private static int randomFadeTime() {
        int baseTime = ((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getCommon().fadeoutTimeTicks;
        int random = (int)(80.0 * Math.random() - 40.0);
        return baseTime + random;
    }

    public static void doServersideRendering(class_3222 player, Collection<SearchResult> results) {
        WhereIsIt.LOGGER.debug("Doing server-side rendering for {}", (Object)player.method_5820());
        class_3218 level = player.method_51469();
        for (SearchResult result : results) {
            Colour colour = Colour.fromHSV((float)((float)Math.random()), (float)1.0f, (float)1.0f);
            int timeoutTicks = ServerSideRenderer.randomFadeTime();
            class_243 mainPos = class_243.method_24955((class_2382)result.pos().method_10084());
            if (result.name() != null) {
                mainPos = mainPos.method_1019(result.nameOffset().method_1023(0.0, 1.0, 0.0));
            }
            BlockDisplayBuilder mainEntity = (BlockDisplayBuilder)((BlockDisplayBuilder)((BlockDisplayBuilder)EntityBuilders.blockDisplay((class_3218)level).position(mainPos)).state(MAIN_BLOCK.method_9564()).scaleAndCenter(0.7f).addTranslation(new Vector3f(0.0f, -0.5f, 0.0f))).glowing(true, colour);
            if (result.name() != null) {
                ((BlockDisplayBuilder)mainEntity.customName(result.name())).alwaysRenderName(true);
                mainEntity.addTranslation(result.nameOffset().method_1023(0.0, 1.0, 0.0).method_22882().method_46409());
            }
            EntityLie main = EntityLie.builder((class_1297)((class_8113.class_8115)mainEntity.build())).onFade((player1, lie) -> playerHighlightLies.remove((Object)player1.method_7334(), (Object)lie)).createAndShow(new class_3222[]{player});
            playerHighlightLies.put((Object)player.method_7334(), (Object)main);
            Debris.INSTANCE.schedule((Lie)main, (long)timeoutTicks);
            for (class_2338 otherPos : result.otherPositions()) {
                EntityLie proxy = EntityLie.builder((class_1297)ServerSideRenderer.makeAlternateBlockDisplay(level, otherPos, colour)).onFade((player1, lie) -> playerHighlightLies.remove((Object)player1.method_7334(), (Object)lie)).createAndShow(new class_3222[]{player});
                playerHighlightLies.put((Object)player.method_7334(), (Object)proxy);
                Debris.INSTANCE.schedule((Lie)proxy, (long)timeoutTicks);
            }
        }
    }
}

