/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.client;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import red.jackf.jackfredlib.api.base.Memoizer;
import red.jackf.jackfredlib.client.api.toasts.CustomToast;
import red.jackf.jackfredlib.client.api.toasts.ToastBuilder;
import red.jackf.jackfredlib.client.api.toasts.ToastFormat;
import red.jackf.jackfredlib.client.api.toasts.ToastIcon;
import red.jackf.jackfredlib.client.api.toasts.Toasts;
import red.jackf.whereisit.api.SearchRequest;
import red.jackf.whereisit.api.SearchResult;
import red.jackf.whereisit.client.api.events.OnResult;
import red.jackf.whereisit.client.api.events.OnResultsCleared;
import red.jackf.whereisit.client.api.events.SearchInvoker;
import red.jackf.whereisit.client.api.events.SearchRequestPopulator;
import red.jackf.whereisit.client.api.events.ShouldIgnoreKey;
import red.jackf.whereisit.client.plugin.WhereIsItClientPluginLoader;
import red.jackf.whereisit.client.render.CurrentGradientHolder;
import red.jackf.whereisit.client.render.Rendering;
import red.jackf.whereisit.client.util.TextUtil;
import red.jackf.whereisit.config.WhereIsItConfig;

@Environment(value=EnvType.CLIENT)
public class WhereIsItClient
implements ClientModInitializer {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final class_304 SEARCH = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.whereisit.search", class_3675.class_307.field_1668, 89, "key.categories.whereisit"));
    public static final int POST_FADEOUT_REPEAT_PERIOD_TICKS = 400;
    private boolean inGame = false;
    public static boolean closedScreenThisSearch = false;
    private static final Supplier<CustomToast> NOT_INSTALLED = Memoizer.of(() -> ToastBuilder.builder((ToastFormat)ToastFormat.DARK, (class_2561)class_2561.method_43471((String)"whereisit.config.title")).addMessage((class_2561)class_2561.method_43471((String)"gui.whereisit.not_installed_serverside")).progressShowsVisibleTime().withIcon(ToastIcon.modIcon((String)"whereisit")).build());

    public void onInitializeClient() {
        LOGGER.debug("Setup Client");
        CurrentGradientHolder.refreshColourScheme();
        ScreenEvents.BEFORE_INIT.register((client, _screen, scaledWidth, scaledHeight) -> {
            if (this.inGame) {
                ScreenKeyboardEvents.afterKeyPress((class_437)_screen).register((screen, key, scancode, modifiers) -> {
                    if (SEARCH.method_1417(key, scancode) && !((ShouldIgnoreKey)ShouldIgnoreKey.EVENT.invoker()).shouldIgnoreKey()) {
                        SearchRequest request = WhereIsItClient.createRequest(client, screen);
                        if (request.hasCriteria()) {
                            SearchInvoker.doSearch(request);
                        } else {
                            Rendering.resetSearchTime();
                        }
                    }
                });
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            this.inGame = true;
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            this.inGame = false;
            WhereIsItClient.clearResults();
        });
        ClientTickEvents.START_WORLD_TICK.register(level -> {
            Rendering.incrementTicksSinceSearch();
            if (Rendering.getTicksSinceSearch() > (long)(((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getCommon().fadeoutTimeTicks + 400)) {
                WhereIsItClient.clearResults();
            }
            if (class_310.method_1551().field_1755 == null && SEARCH.method_1436()) {
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) {
                    return;
                }
                class_1799 item = player.method_5998(class_1268.field_5808);
                if (item.method_7960()) {
                    item = player.method_5998(class_1268.field_5810);
                }
                if (!item.method_7960() && ((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getClient().searchUsingItemInHand) {
                    SearchRequest request = new SearchRequest();
                    SearchRequestPopulator.addItemStack(request, item, SearchRequestPopulator.Context.inventory());
                    if (request.hasCriteria()) {
                        SearchInvoker.doSearch(request);
                    }
                } else {
                    Rendering.resetSearchTime();
                }
            }
        });
        WhereIsItClientPluginLoader.load();
        Rendering.setup();
    }

    public static boolean doSearch(SearchRequest request) {
        boolean anySucceeded;
        Rendering.resetSearchTime();
        WhereIsItClient.updateRendering(request);
        LOGGER.debug("Starting request: %s".formatted(request));
        if (((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getClient().debug.printSearchRequestsInChat && class_310.method_1551().field_1724 != null) {
            List<class_2561> text = TextUtil.prettyPrint((class_2520)request.toTag());
            for (class_2561 component : text) {
                class_310.method_1551().field_1724.method_7353(component, false);
            }
        }
        if (!(anySucceeded = ((SearchInvoker)SearchInvoker.EVENT.invoker()).search(request, WhereIsItClient::recieveResults))) {
            Toasts.INSTANCE.send(NOT_INSTALLED.get());
        } else if (((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getClient().playSoundOnRequest) {
            WhereIsItClient.playRequestSound();
        }
        return anySucceeded;
    }

    public static void recieveResults(Collection<SearchResult> results) {
        LOGGER.debug("Search results: %s".formatted(results));
        if (((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getClient().closeGuiOnFoundResults && !closedScreenThisSearch) {
            closedScreenThisSearch = true;
            if (class_310.method_1551().field_1755 != null && class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7346();
            }
        }
        ((OnResult)OnResult.EVENT.invoker()).onResults(results);
    }

    private static void clearResults() {
        ((OnResultsCleared)OnResultsCleared.EVENT.invoker()).onResultsCleared();
    }

    private static void updateRendering(SearchRequest request) {
        WhereIsItClient.clearResults();
        Rendering.setLastRequest(request);
        closedScreenThisSearch = false;
        CurrentGradientHolder.refreshColourScheme();
    }

    @NotNull
    private static SearchRequest createRequest(class_310 client, class_437 screen1) {
        int mouseX = (int)(client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480());
        int mouseY = (int)(client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507());
        SearchRequest request = new SearchRequest();
        ((SearchRequestPopulator)SearchRequestPopulator.EVENT.invoker()).grabStack(request, screen1, mouseX, mouseY);
        return request;
    }

    private static void playRequestSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_14725.comp_349()), (float)2.0f, (float)0.5f));
    }
}

