/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.client.api.events;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import red.jackf.whereisit.api.SearchRequest;
import red.jackf.whereisit.api.criteria.Criterion;
import red.jackf.whereisit.api.criteria.builtin.AllOfCriterion;
import red.jackf.whereisit.api.criteria.builtin.ComponentsCriterion;
import red.jackf.whereisit.api.criteria.builtin.EnchantmentCriterion;
import red.jackf.whereisit.api.criteria.builtin.ItemCriterion;
import red.jackf.whereisit.api.criteria.builtin.NameCriterion;
import red.jackf.whereisit.api.criteria.builtin.PotionEffectCriterion;
import red.jackf.whereisit.client.WhereIsItClient;
import red.jackf.whereisit.client.api.events.OverlayStackBehavior;

@Environment(value=EnvType.CLIENT)
public interface SearchRequestPopulator {
    public static final Event<SearchRequestPopulator> EVENT = EventFactory.createArrayBacked(SearchRequestPopulator.class, listeners -> (request, screen, mouseX, mouseY) -> {
        for (SearchRequestPopulator listener : listeners) {
            try {
                listener.grabStack(request, screen, mouseX, mouseY);
                if (!request.hasCriteria()) continue;
                break;
            }
            catch (Exception ex) {
                WhereIsItClient.LOGGER.error("Error populating from stack, class %s".formatted(listener.getClass().getName()), (Throwable)ex);
            }
        }
    });

    public void grabStack(SearchRequest var1, class_437 var2, int var3, int var4);

    public static void addItemStack(Consumer<Criterion> consumer, class_1799 stack, Context context) {
        WhereIsItClient.LOGGER.debug("Adding {}, context: {}", (Object)stack, (Object)context);
        ArrayList<Criterion> criterion = new ArrayList<Criterion>();
        boolean triggeredOverlayBehavior = false;
        if (context == Context.OVERLAY || context == Context.OVERLAY_ALTERNATE) {
            triggeredOverlayBehavior = ((OverlayStackBehavior)OverlayStackBehavior.EVENT.invoker()).processOverlayStackBehavior(criterion::add, stack, context == Context.OVERLAY_ALTERNATE);
        }
        if (!triggeredOverlayBehavior) {
            criterion.add(new ItemCriterion(stack.method_7909()));
            if (context == Context.INVENTORY_PRECISE || context == Context.OVERLAY_ALTERNATE) {
                criterion.add(new ComponentsCriterion(stack.method_57380()));
            } else if (context == Context.FAVOURITE) {
                class_1844 potion;
                class_9304 enchantments;
                if (stack.method_57826(class_9334.field_49631)) {
                    criterion.add(new NameCriterion(stack.method_7964().getString()));
                }
                if ((enchantments = (class_9304)stack.method_58694(class_1890.method_57533((class_1799)stack))) != null) {
                    for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                        criterion.add(new EnchantmentCriterion((class_6880<class_1887>)((class_6880)entry.getKey()), entry.getIntValue()));
                    }
                }
                if ((potion = (class_1844)stack.method_58694(class_9334.field_49651)) != null && potion.comp_2378().isPresent()) {
                    criterion.add(new PotionEffectCriterion((class_1842)((class_6880)potion.comp_2378().get()).comp_349()));
                }
            }
        }
        consumer.accept(new AllOfCriterion(criterion).compact());
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Context {
        INVENTORY,
        INVENTORY_PRECISE,
        RECIPE,
        OVERLAY,
        OVERLAY_ALTERNATE,
        FAVOURITE;


        public static Context inventory() {
            return class_437.method_25442() ? INVENTORY_PRECISE : INVENTORY;
        }

        public static Context overlay() {
            return class_437.method_25442() ? OVERLAY_ALTERNATE : OVERLAY;
        }
    }
}

