/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.client.compat.recipeviewers;

import dev.architectury.fluid.FluidStack;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.TextField;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import red.jackf.whereisit.api.SearchRequest;
import red.jackf.whereisit.api.criteria.Criterion;
import red.jackf.whereisit.api.criteria.builtin.AnyOfCriterion;
import red.jackf.whereisit.api.criteria.builtin.FluidCriterion;
import red.jackf.whereisit.api.criteria.builtin.ItemTagCriterion;
import red.jackf.whereisit.client.WhereIsItClient;
import red.jackf.whereisit.client.api.events.SearchRequestPopulator;
import red.jackf.whereisit.client.api.events.ShouldIgnoreKey;
import red.jackf.whereisit.client.compat.CompatUtils;
import red.jackf.whereisit.config.WhereIsItConfig;

@Environment(value=EnvType.CLIENT)
public class WhereIsItREIPlugin
implements REIClientPlugin {
    private boolean hasErrored = false;

    public WhereIsItREIPlugin() {
        WhereIsItClient.LOGGER.info("Hooking into REI");
        SearchRequestPopulator.EVENT.register((request, screen, mouseX, mouseY) -> {
            if (!((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getClient().compatibility.reiSupport) {
                return;
            }
            if (this.hasErrored) {
                return;
            }
            try {
                if (REIRuntime.getInstance().isOverlayVisible() && WhereIsItREIPlugin.getFromOverlay(request)) {
                    return;
                }
                if (screen instanceof DisplayScreen) {
                    WhereIsItREIPlugin.getFromRecipeScreen(request, screen, mouseX, mouseY);
                }
            }
            catch (Exception ex) {
                CompatUtils.LOGGER.error("Error in REI handler, disabling", (Throwable)ex);
                this.hasErrored = true;
            }
        });
        ShouldIgnoreKey.EVENT.register(() -> {
            TextField textField = REIRuntime.getInstance().getSearchTextField();
            return textField != null && textField.method_25370();
        });
    }

    private static boolean getFromOverlay(SearchRequest request) {
        EntryStack hoveredFavourite;
        Optional overlayOpt = REIRuntime.getInstance().getOverlay();
        if (overlayOpt.isEmpty()) {
            return true;
        }
        ScreenOverlay overlay = (ScreenOverlay)overlayOpt.get();
        EntryStack hoveredEntry = overlay.getEntryList().getFocusedStack();
        if (!hoveredEntry.isEmpty()) {
            WhereIsItREIPlugin.parseEntryStack(request, hoveredEntry, SearchRequestPopulator.Context.overlay());
            return true;
        }
        Optional favourites = overlay.getFavoritesList();
        if (favourites.isPresent() && !(hoveredFavourite = ((OverlayListWidget)favourites.get()).getFocusedStack()).isEmpty()) {
            WhereIsItREIPlugin.parseEntryStack(request, hoveredFavourite, SearchRequestPopulator.Context.FAVOURITE);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void getFromRecipeScreen(SearchRequest request, class_437 screen, int mouseX, int mouseY) {
        Iterator iterator = Widgets.walk((Iterable)screen.method_25396(), g -> {
            Slot slot;
            return g instanceof Slot && (slot = (Slot)g).method_25405((double)mouseX, (double)mouseY);
        }).iterator();
        if (!iterator.hasNext()) return;
        Object widget = iterator.next();
        Slot slot = (Slot)widget;
        if (slot instanceof EntryWidget) {
            EntryWidget entryWidget = (EntryWidget)slot;
            if (entryWidget.tagMatch != null) {
                class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)entryWidget.tagMatch);
                if (!class_7923.field_41178.method_46733(key).isPresent()) return;
                request.accept(new ItemTagCriterion((class_6862<class_1792>)key));
                return;
            }
        }
        AnyOfCriterion criteria = new AnyOfCriterion();
        Iterator iterator2 = slot.getEntries().iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                request.accept(criteria.compact());
                return;
            }
            EntryStack entry = (EntryStack)iterator2.next();
            WhereIsItREIPlugin.parseEntryStack(criteria, entry, SearchRequestPopulator.Context.RECIPE);
        }
    }

    private static void parseEntryStack(Consumer<Criterion> consumer, EntryStack<?> entryStack, SearchRequestPopulator.Context context) {
        Object value = entryStack.getValue();
        if (value instanceof class_1799) {
            class_1799 stack = (class_1799)value;
            SearchRequestPopulator.addItemStack(consumer, stack, context);
        } else if (value instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)value;
            consumer.accept(new FluidCriterion(fluidStack.getFluid()));
        }
    }
}

